package zio.aws.sagemakermetrics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemakermetrics.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class BatchPutMetricsError(
    code: Optional[zio.aws.sagemakermetrics.model.PutMetricsErrorCode] =
      Optional.Absent,
    metricIndex: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakermetrics.model.BatchPutMetricsError = {
    import BatchPutMetricsError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakermetrics.model.BatchPutMetricsError
      .builder()
      .optionallyWith(code.map(value => value.unwrap))(_.code)
      .optionallyWith(metricIndex.map(value => value: java.lang.Integer))(
        _.metricIndex
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemakermetrics.model.BatchPutMetricsError.ReadOnly =
    zio.aws.sagemakermetrics.model.BatchPutMetricsError.wrap(buildAwsValue())
}
object BatchPutMetricsError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakermetrics.model.BatchPutMetricsError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakermetrics.model.BatchPutMetricsError =
      zio.aws.sagemakermetrics.model.BatchPutMetricsError(
        code.map(value => value),
        metricIndex.map(value => value)
      )
    def code: Optional[zio.aws.sagemakermetrics.model.PutMetricsErrorCode]
    def metricIndex: Optional[Integer]
    def getCode: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakermetrics.model.PutMetricsErrorCode
    ] = AwsError.unwrapOptionField("code", code)
    def getMetricIndex: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("metricIndex", metricIndex)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakermetrics.model.BatchPutMetricsError
  ) extends zio.aws.sagemakermetrics.model.BatchPutMetricsError.ReadOnly {
    override val code
        : Optional[zio.aws.sagemakermetrics.model.PutMetricsErrorCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.code())
        .map(value =>
          zio.aws.sagemakermetrics.model.PutMetricsErrorCode.wrap(value)
        )
    override val metricIndex: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.metricIndex())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakermetrics.model.BatchPutMetricsError
  ): zio.aws.sagemakermetrics.model.BatchPutMetricsError.ReadOnly = new Wrapper(
    impl
  )
}
