package zio.aws.sagemakermetrics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchPutMetricsResponse(
    errors: Optional[
      Iterable[zio.aws.sagemakermetrics.model.BatchPutMetricsError]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakermetrics.model.BatchPutMetricsResponse = {
    import BatchPutMetricsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakermetrics.model.BatchPutMetricsResponse
      .builder()
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakermetrics.model.BatchPutMetricsResponse.ReadOnly =
    zio.aws.sagemakermetrics.model.BatchPutMetricsResponse.wrap(buildAwsValue())
}
object BatchPutMetricsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakermetrics.model.BatchPutMetricsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakermetrics.model.BatchPutMetricsResponse =
      zio.aws.sagemakermetrics.model.BatchPutMetricsResponse(
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def errors: Optional[
      List[zio.aws.sagemakermetrics.model.BatchPutMetricsError.ReadOnly]
    ]
    def getErrors: ZIO[Any, AwsError, List[
      zio.aws.sagemakermetrics.model.BatchPutMetricsError.ReadOnly
    ]] = AwsError.unwrapOptionField("errors", errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakermetrics.model.BatchPutMetricsResponse
  ) extends zio.aws.sagemakermetrics.model.BatchPutMetricsResponse.ReadOnly {
    override val errors: Optional[
      List[zio.aws.sagemakermetrics.model.BatchPutMetricsError.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.errors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemakermetrics.model.BatchPutMetricsError.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakermetrics.model.BatchPutMetricsResponse
  ): zio.aws.sagemakermetrics.model.BatchPutMetricsResponse.ReadOnly =
    new Wrapper(impl)
}
