package zio.aws.sagemakergeospatial.model
import zio.aws.sagemakergeospatial.model.primitives.Timestamp
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class TimeRangeFilterInput(
    endTime: Timestamp,
    startTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.TimeRangeFilterInput = {
    import TimeRangeFilterInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.TimeRangeFilterInput
      .builder()
      .endTime(Timestamp.unwrap(endTime): Instant)
      .startTime(Timestamp.unwrap(startTime): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.TimeRangeFilterInput.ReadOnly =
    zio.aws.sagemakergeospatial.model.TimeRangeFilterInput.wrap(buildAwsValue())
}
object TimeRangeFilterInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.TimeRangeFilterInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakergeospatial.model.TimeRangeFilterInput =
      zio.aws.sagemakergeospatial.model.TimeRangeFilterInput(endTime, startTime)
    def endTime: Timestamp
    def startTime: Timestamp
    def getEndTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endTime)
    def getStartTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.TimeRangeFilterInput
  ) extends zio.aws.sagemakergeospatial.model.TimeRangeFilterInput.ReadOnly {
    override val endTime: Timestamp =
      zio.aws.sagemakergeospatial.model.primitives.Timestamp(impl.endTime())
    override val startTime: Timestamp =
      zio.aws.sagemakergeospatial.model.primitives.Timestamp(impl.startTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.TimeRangeFilterInput
  ): zio.aws.sagemakergeospatial.model.TimeRangeFilterInput.ReadOnly =
    new Wrapper(impl)
}
