package zio.aws.sagemakergeospatial.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ResamplingConfigInput(
    algorithmName: Optional[
      zio.aws.sagemakergeospatial.model.AlgorithmNameResampling
    ] = Optional.Absent,
    outputResolution: zio.aws.sagemakergeospatial.model.OutputResolutionResamplingInput,
    targetBands: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.ResamplingConfigInput = {
    import ResamplingConfigInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.ResamplingConfigInput
      .builder()
      .optionallyWith(algorithmName.map(value => value.unwrap))(_.algorithmName)
      .outputResolution(outputResolution.buildAwsValue())
      .optionallyWith(
        targetBands.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.targetBands)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.ResamplingConfigInput.ReadOnly =
    zio.aws.sagemakergeospatial.model.ResamplingConfigInput
      .wrap(buildAwsValue())
}
object ResamplingConfigInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.ResamplingConfigInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakergeospatial.model.ResamplingConfigInput =
      zio.aws.sagemakergeospatial.model.ResamplingConfigInput(
        algorithmName.map(value => value),
        outputResolution.asEditable,
        targetBands.map(value => value)
      )
    def algorithmName
        : Optional[zio.aws.sagemakergeospatial.model.AlgorithmNameResampling]
    def outputResolution
        : zio.aws.sagemakergeospatial.model.OutputResolutionResamplingInput.ReadOnly
    def targetBands: Optional[List[String]]
    def getAlgorithmName: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.AlgorithmNameResampling
    ] = AwsError.unwrapOptionField("algorithmName", algorithmName)
    def getOutputResolution: ZIO[
      Any,
      Nothing,
      zio.aws.sagemakergeospatial.model.OutputResolutionResamplingInput.ReadOnly
    ] = ZIO.succeed(outputResolution)
    def getTargetBands: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("targetBands", targetBands)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.ResamplingConfigInput
  ) extends zio.aws.sagemakergeospatial.model.ResamplingConfigInput.ReadOnly {
    override val algorithmName
        : Optional[zio.aws.sagemakergeospatial.model.AlgorithmNameResampling] =
      zio.aws.core.internal
        .optionalFromNullable(impl.algorithmName())
        .map(value =>
          zio.aws.sagemakergeospatial.model.AlgorithmNameResampling.wrap(value)
        )
    override val outputResolution
        : zio.aws.sagemakergeospatial.model.OutputResolutionResamplingInput.ReadOnly =
      zio.aws.sagemakergeospatial.model.OutputResolutionResamplingInput
        .wrap(impl.outputResolution())
    override val targetBands: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.targetBands())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.ResamplingConfigInput
  ): zio.aws.sagemakergeospatial.model.ResamplingConfigInput.ReadOnly =
    new Wrapper(impl)
}
