package zio.aws.sagemakergeospatial
import zio.aws.sagemakergeospatial.model.GetVectorEnrichmentJobResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.sagemakergeospatial.{
  SageMakerGeospatialAsyncClientBuilder,
  SageMakerGeospatialAsyncClient
}
import zio.aws.sagemakergeospatial.model.{
  StopEarthObservationJobRequest,
  DeleteVectorEnrichmentJobRequest,
  ListRasterDataCollectionsRequest,
  GetEarthObservationJobRequest,
  ListEarthObservationJobsRequest,
  SearchRasterDataCollectionRequest,
  GetTileRequest,
  DeleteEarthObservationJobRequest,
  ListTagsForResourceRequest,
  GetRasterDataCollectionRequest,
  StartVectorEnrichmentJobRequest,
  StartEarthObservationJobRequest,
  GetVectorEnrichmentJobRequest,
  ExportEarthObservationJobRequest,
  StopVectorEnrichmentJobRequest,
  UntagResourceRequest,
  ExportVectorEnrichmentJobRequest,
  TagResourceRequest,
  ListVectorEnrichmentJobsRequest
}
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, Task, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import software.amazon.awssdk.services.sagemakergeospatial.model.{
  ListVectorEnrichmentJobsResponse,
  DeleteEarthObservationJobResponse,
  StartEarthObservationJobResponse,
  GetVectorEnrichmentJobResponse,
  GetTileResponse,
  RasterDataCollectionMetadata,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  StartVectorEnrichmentJobResponse,
  SearchRasterDataCollectionResponse,
  StopVectorEnrichmentJobResponse,
  ExportEarthObservationJobResponse,
  ListVectorEnrichmentJobOutputConfig,
  ListEarthObservationJobsResponse,
  GetRasterDataCollectionResponse,
  ExportVectorEnrichmentJobResponse,
  StopEarthObservationJobResponse,
  ListEarthObservationJobOutputConfig,
  ListRasterDataCollectionsResponse,
  ItemSource,
  DeleteVectorEnrichmentJobResponse,
  GetEarthObservationJobResponse,
  TagResourceResponse
}
import scala.jdk.CollectionConverters.*
trait SageMakerGeospatial extends AspectSupport[SageMakerGeospatial] {
  val api: SageMakerGeospatialAsyncClient
  def getVectorEnrichmentJob(
      request: GetVectorEnrichmentJobRequest
  ): IO[AwsError, ReadOnly]
  def stopVectorEnrichmentJob(request: StopVectorEnrichmentJobRequest): IO[
    AwsError,
    zio.aws.sagemakergeospatial.model.StopVectorEnrichmentJobResponse.ReadOnly
  ]
  def startVectorEnrichmentJob(request: StartVectorEnrichmentJobRequest): IO[
    AwsError,
    zio.aws.sagemakergeospatial.model.StartVectorEnrichmentJobResponse.ReadOnly
  ]
  def startEarthObservationJob(request: StartEarthObservationJobRequest): IO[
    AwsError,
    zio.aws.sagemakergeospatial.model.StartEarthObservationJobResponse.ReadOnly
  ]
  def getEarthObservationJob(request: GetEarthObservationJobRequest): IO[
    AwsError,
    zio.aws.sagemakergeospatial.model.GetEarthObservationJobResponse.ReadOnly
  ]
  def listEarthObservationJobs(
      request: ListEarthObservationJobsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.sagemakergeospatial.model.ListEarthObservationJobOutputConfig.ReadOnly
  ]
  def listEarthObservationJobsPaginated(
      request: ListEarthObservationJobsRequest
  ): IO[
    AwsError,
    zio.aws.sagemakergeospatial.model.ListEarthObservationJobsResponse.ReadOnly
  ]
  def listRasterDataCollections(
      request: ListRasterDataCollectionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.sagemakergeospatial.model.RasterDataCollectionMetadata.ReadOnly
  ]
  def listRasterDataCollectionsPaginated(
      request: ListRasterDataCollectionsRequest
  ): IO[
    AwsError,
    zio.aws.sagemakergeospatial.model.ListRasterDataCollectionsResponse.ReadOnly
  ]
  def deleteEarthObservationJob(request: DeleteEarthObservationJobRequest): IO[
    AwsError,
    zio.aws.sagemakergeospatial.model.DeleteEarthObservationJobResponse.ReadOnly
  ]
  def untagResource(request: UntagResourceRequest): IO[
    AwsError,
    zio.aws.sagemakergeospatial.model.UntagResourceResponse.ReadOnly
  ]
  def listTagsForResource(request: ListTagsForResourceRequest): IO[
    AwsError,
    zio.aws.sagemakergeospatial.model.ListTagsForResourceResponse.ReadOnly
  ]
  def tagResource(request: TagResourceRequest): IO[
    AwsError,
    zio.aws.sagemakergeospatial.model.TagResourceResponse.ReadOnly
  ]
  def deleteVectorEnrichmentJob(request: DeleteVectorEnrichmentJobRequest): IO[
    AwsError,
    zio.aws.sagemakergeospatial.model.DeleteVectorEnrichmentJobResponse.ReadOnly
  ]
  def exportVectorEnrichmentJob(request: ExportVectorEnrichmentJobRequest): IO[
    AwsError,
    zio.aws.sagemakergeospatial.model.ExportVectorEnrichmentJobResponse.ReadOnly
  ]
  def getTile(request: GetTileRequest): IO[AwsError, StreamingOutputResult[
    Any,
    zio.aws.sagemakergeospatial.model.GetTileResponse.ReadOnly,
    Byte
  ]]
  def listVectorEnrichmentJobs(
      request: ListVectorEnrichmentJobsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.sagemakergeospatial.model.ListVectorEnrichmentJobOutputConfig.ReadOnly
  ]
  def listVectorEnrichmentJobsPaginated(
      request: ListVectorEnrichmentJobsRequest
  ): IO[
    AwsError,
    zio.aws.sagemakergeospatial.model.ListVectorEnrichmentJobsResponse.ReadOnly
  ]
  def getRasterDataCollection(request: GetRasterDataCollectionRequest): IO[
    AwsError,
    zio.aws.sagemakergeospatial.model.GetRasterDataCollectionResponse.ReadOnly
  ]
  def exportEarthObservationJob(request: ExportEarthObservationJobRequest): IO[
    AwsError,
    zio.aws.sagemakergeospatial.model.ExportEarthObservationJobResponse.ReadOnly
  ]
  def stopEarthObservationJob(request: StopEarthObservationJobRequest): IO[
    AwsError,
    zio.aws.sagemakergeospatial.model.StopEarthObservationJobResponse.ReadOnly
  ]
  def searchRasterDataCollection(
      request: SearchRasterDataCollectionRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.sagemakergeospatial.model.SearchRasterDataCollectionResponse.ReadOnly,
    zio.aws.sagemakergeospatial.model.ItemSource.ReadOnly
  ]]
  def searchRasterDataCollectionPaginated(
      request: SearchRasterDataCollectionRequest
  ): IO[
    AwsError,
    zio.aws.sagemakergeospatial.model.SearchRasterDataCollectionResponse.ReadOnly
  ]
}
object SageMakerGeospatial {
  val live: ZLayer[AwsConfig, java.lang.Throwable, SageMakerGeospatial] =
    customized(identity)
  def customized(
      customization: SageMakerGeospatialAsyncClientBuilder => SageMakerGeospatialAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, SageMakerGeospatial] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: SageMakerGeospatialAsyncClientBuilder => SageMakerGeospatialAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, SageMakerGeospatial] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = SageMakerGeospatialAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[
      SageMakerGeospatialAsyncClient,
      SageMakerGeospatialAsyncClientBuilder
    ](builder);
    b1 <- awsConfig.configureHttpClient[
      SageMakerGeospatialAsyncClient,
      SageMakerGeospatialAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new SageMakerGeospatialImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class SageMakerGeospatialImpl[R](
      override val api: SageMakerGeospatialAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends SageMakerGeospatial
      with AwsServiceBase[R] {
    override val serviceName: String = "SageMakerGeospatial"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): SageMakerGeospatialImpl[R1] =
      new SageMakerGeospatialImpl(api, newAspect, r)
    def getVectorEnrichmentJob(
        request: GetVectorEnrichmentJobRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemakergeospatial.model.GetVectorEnrichmentJobRequest,
      GetVectorEnrichmentJobResponse
    ]("getVectorEnrichmentJob", api.getVectorEnrichmentJob)(
      request.buildAwsValue()
    ).map(zio.aws.sagemakergeospatial.model.GetVectorEnrichmentJobResponse.wrap)
      .provideEnvironment(r)
    def stopVectorEnrichmentJob(request: StopVectorEnrichmentJobRequest): IO[
      AwsError,
      zio.aws.sagemakergeospatial.model.StopVectorEnrichmentJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemakergeospatial.model.StopVectorEnrichmentJobRequest,
      StopVectorEnrichmentJobResponse
    ]("stopVectorEnrichmentJob", api.stopVectorEnrichmentJob)(
      request.buildAwsValue()
    ).map(
      zio.aws.sagemakergeospatial.model.StopVectorEnrichmentJobResponse.wrap
    ).provideEnvironment(r)
    def startVectorEnrichmentJob(request: StartVectorEnrichmentJobRequest): IO[
      AwsError,
      zio.aws.sagemakergeospatial.model.StartVectorEnrichmentJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemakergeospatial.model.StartVectorEnrichmentJobRequest,
      StartVectorEnrichmentJobResponse
    ]("startVectorEnrichmentJob", api.startVectorEnrichmentJob)(
      request.buildAwsValue()
    ).map(
      zio.aws.sagemakergeospatial.model.StartVectorEnrichmentJobResponse.wrap
    ).provideEnvironment(r)
    def startEarthObservationJob(request: StartEarthObservationJobRequest): IO[
      AwsError,
      zio.aws.sagemakergeospatial.model.StartEarthObservationJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemakergeospatial.model.StartEarthObservationJobRequest,
      StartEarthObservationJobResponse
    ]("startEarthObservationJob", api.startEarthObservationJob)(
      request.buildAwsValue()
    ).map(
      zio.aws.sagemakergeospatial.model.StartEarthObservationJobResponse.wrap
    ).provideEnvironment(r)
    def getEarthObservationJob(request: GetEarthObservationJobRequest): IO[
      AwsError,
      zio.aws.sagemakergeospatial.model.GetEarthObservationJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemakergeospatial.model.GetEarthObservationJobRequest,
      GetEarthObservationJobResponse
    ]("getEarthObservationJob", api.getEarthObservationJob)(
      request.buildAwsValue()
    ).map(zio.aws.sagemakergeospatial.model.GetEarthObservationJobResponse.wrap)
      .provideEnvironment(r)
    def listEarthObservationJobs(
        request: ListEarthObservationJobsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.ListEarthObservationJobOutputConfig.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.sagemakergeospatial.model.ListEarthObservationJobsRequest,
      ListEarthObservationJobsResponse,
      ListEarthObservationJobOutputConfig
    ](
      "listEarthObservationJobs",
      api.listEarthObservationJobs,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.earthObservationJobSummaries().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.sagemakergeospatial.model.ListEarthObservationJobOutputConfig
          .wrap(item)
      )
      .provideEnvironment(r)
    def listEarthObservationJobsPaginated(
        request: ListEarthObservationJobsRequest
    ): IO[
      AwsError,
      zio.aws.sagemakergeospatial.model.ListEarthObservationJobsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemakergeospatial.model.ListEarthObservationJobsRequest,
      ListEarthObservationJobsResponse
    ]("listEarthObservationJobs", api.listEarthObservationJobs)(
      request.buildAwsValue()
    ).map(
      zio.aws.sagemakergeospatial.model.ListEarthObservationJobsResponse.wrap
    ).provideEnvironment(r)
    def listRasterDataCollections(
        request: ListRasterDataCollectionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.RasterDataCollectionMetadata.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.sagemakergeospatial.model.ListRasterDataCollectionsRequest,
      ListRasterDataCollectionsResponse,
      RasterDataCollectionMetadata
    ](
      "listRasterDataCollections",
      api.listRasterDataCollections,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.rasterDataCollectionSummaries().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.sagemakergeospatial.model.RasterDataCollectionMetadata
          .wrap(item)
      )
      .provideEnvironment(r)
    def listRasterDataCollectionsPaginated(
        request: ListRasterDataCollectionsRequest
    ): IO[
      AwsError,
      zio.aws.sagemakergeospatial.model.ListRasterDataCollectionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemakergeospatial.model.ListRasterDataCollectionsRequest,
      ListRasterDataCollectionsResponse
    ]("listRasterDataCollections", api.listRasterDataCollections)(
      request.buildAwsValue()
    ).map(
      zio.aws.sagemakergeospatial.model.ListRasterDataCollectionsResponse.wrap
    ).provideEnvironment(r)
    def deleteEarthObservationJob(
        request: DeleteEarthObservationJobRequest
    ): IO[
      AwsError,
      zio.aws.sagemakergeospatial.model.DeleteEarthObservationJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemakergeospatial.model.DeleteEarthObservationJobRequest,
      DeleteEarthObservationJobResponse
    ]("deleteEarthObservationJob", api.deleteEarthObservationJob)(
      request.buildAwsValue()
    ).map(
      zio.aws.sagemakergeospatial.model.DeleteEarthObservationJobResponse.wrap
    ).provideEnvironment(r)
    def untagResource(request: UntagResourceRequest): IO[
      AwsError,
      zio.aws.sagemakergeospatial.model.UntagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemakergeospatial.model.UntagResourceRequest,
      UntagResourceResponse
    ]("untagResource", api.untagResource)(request.buildAwsValue())
      .map(zio.aws.sagemakergeospatial.model.UntagResourceResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.sagemakergeospatial.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemakergeospatial.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.sagemakergeospatial.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(request: TagResourceRequest): IO[
      AwsError,
      zio.aws.sagemakergeospatial.model.TagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemakergeospatial.model.TagResourceRequest,
      TagResourceResponse
    ]("tagResource", api.tagResource)(request.buildAwsValue())
      .map(zio.aws.sagemakergeospatial.model.TagResourceResponse.wrap)
      .provideEnvironment(r)
    def deleteVectorEnrichmentJob(
        request: DeleteVectorEnrichmentJobRequest
    ): IO[
      AwsError,
      zio.aws.sagemakergeospatial.model.DeleteVectorEnrichmentJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemakergeospatial.model.DeleteVectorEnrichmentJobRequest,
      DeleteVectorEnrichmentJobResponse
    ]("deleteVectorEnrichmentJob", api.deleteVectorEnrichmentJob)(
      request.buildAwsValue()
    ).map(
      zio.aws.sagemakergeospatial.model.DeleteVectorEnrichmentJobResponse.wrap
    ).provideEnvironment(r)
    def exportVectorEnrichmentJob(
        request: ExportVectorEnrichmentJobRequest
    ): IO[
      AwsError,
      zio.aws.sagemakergeospatial.model.ExportVectorEnrichmentJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemakergeospatial.model.ExportVectorEnrichmentJobRequest,
      ExportVectorEnrichmentJobResponse
    ]("exportVectorEnrichmentJob", api.exportVectorEnrichmentJob)(
      request.buildAwsValue()
    ).map(
      zio.aws.sagemakergeospatial.model.ExportVectorEnrichmentJobResponse.wrap
    ).provideEnvironment(r)
    def getTile(request: GetTileRequest): IO[AwsError, StreamingOutputResult[
      Any,
      zio.aws.sagemakergeospatial.model.GetTileResponse.ReadOnly,
      Byte
    ]] = asyncRequestOutputStream[
      software.amazon.awssdk.services.sagemakergeospatial.model.GetTileRequest,
      GetTileResponse
    ](
      "getTile",
      api.getTile[Task[StreamingOutputResult[R, GetTileResponse, Byte]]]
    )(request.buildAwsValue())
      .map(
        _.mapResponse(zio.aws.sagemakergeospatial.model.GetTileResponse.wrap)
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listVectorEnrichmentJobs(
        request: ListVectorEnrichmentJobsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.ListVectorEnrichmentJobOutputConfig.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.sagemakergeospatial.model.ListVectorEnrichmentJobsRequest,
      ListVectorEnrichmentJobsResponse,
      ListVectorEnrichmentJobOutputConfig
    ](
      "listVectorEnrichmentJobs",
      api.listVectorEnrichmentJobs,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.vectorEnrichmentJobSummaries().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.sagemakergeospatial.model.ListVectorEnrichmentJobOutputConfig
          .wrap(item)
      )
      .provideEnvironment(r)
    def listVectorEnrichmentJobsPaginated(
        request: ListVectorEnrichmentJobsRequest
    ): IO[
      AwsError,
      zio.aws.sagemakergeospatial.model.ListVectorEnrichmentJobsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemakergeospatial.model.ListVectorEnrichmentJobsRequest,
      ListVectorEnrichmentJobsResponse
    ]("listVectorEnrichmentJobs", api.listVectorEnrichmentJobs)(
      request.buildAwsValue()
    ).map(
      zio.aws.sagemakergeospatial.model.ListVectorEnrichmentJobsResponse.wrap
    ).provideEnvironment(r)
    def getRasterDataCollection(request: GetRasterDataCollectionRequest): IO[
      AwsError,
      zio.aws.sagemakergeospatial.model.GetRasterDataCollectionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemakergeospatial.model.GetRasterDataCollectionRequest,
      GetRasterDataCollectionResponse
    ]("getRasterDataCollection", api.getRasterDataCollection)(
      request.buildAwsValue()
    ).map(
      zio.aws.sagemakergeospatial.model.GetRasterDataCollectionResponse.wrap
    ).provideEnvironment(r)
    def exportEarthObservationJob(
        request: ExportEarthObservationJobRequest
    ): IO[
      AwsError,
      zio.aws.sagemakergeospatial.model.ExportEarthObservationJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemakergeospatial.model.ExportEarthObservationJobRequest,
      ExportEarthObservationJobResponse
    ]("exportEarthObservationJob", api.exportEarthObservationJob)(
      request.buildAwsValue()
    ).map(
      zio.aws.sagemakergeospatial.model.ExportEarthObservationJobResponse.wrap
    ).provideEnvironment(r)
    def stopEarthObservationJob(request: StopEarthObservationJobRequest): IO[
      AwsError,
      zio.aws.sagemakergeospatial.model.StopEarthObservationJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemakergeospatial.model.StopEarthObservationJobRequest,
      StopEarthObservationJobResponse
    ]("stopEarthObservationJob", api.stopEarthObservationJob)(
      request.buildAwsValue()
    ).map(
      zio.aws.sagemakergeospatial.model.StopEarthObservationJobResponse.wrap
    ).provideEnvironment(r)
    def searchRasterDataCollection(
        request: SearchRasterDataCollectionRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.sagemakergeospatial.model.SearchRasterDataCollectionResponse.ReadOnly,
      zio.aws.sagemakergeospatial.model.ItemSource.ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.sagemakergeospatial.model.SearchRasterDataCollectionRequest,
      SearchRasterDataCollectionResponse,
      ItemSource
    ](
      "searchRasterDataCollection",
      api.searchRasterDataCollection,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.items().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.sagemakergeospatial.model.SearchRasterDataCollectionResponse.wrap
          )
          .mapOutput(
            _.map(item =>
              zio.aws.sagemakergeospatial.model.ItemSource.wrap(item)
            )
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def searchRasterDataCollectionPaginated(
        request: SearchRasterDataCollectionRequest
    ): IO[
      AwsError,
      zio.aws.sagemakergeospatial.model.SearchRasterDataCollectionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.sagemakergeospatial.model.SearchRasterDataCollectionRequest,
      SearchRasterDataCollectionResponse
    ]("searchRasterDataCollection", api.searchRasterDataCollection)(
      request.buildAwsValue()
    ).map(
      zio.aws.sagemakergeospatial.model.SearchRasterDataCollectionResponse.wrap
    ).provideEnvironment(r)
  }
  def getVectorEnrichmentJob(
      request: GetVectorEnrichmentJobRequest
  ): ZIO[zio.aws.sagemakergeospatial.SageMakerGeospatial, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.getVectorEnrichmentJob(request))
  def stopVectorEnrichmentJob(request: StopVectorEnrichmentJobRequest): ZIO[
    zio.aws.sagemakergeospatial.SageMakerGeospatial,
    AwsError,
    zio.aws.sagemakergeospatial.model.StopVectorEnrichmentJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopVectorEnrichmentJob(request))
  def startVectorEnrichmentJob(request: StartVectorEnrichmentJobRequest): ZIO[
    zio.aws.sagemakergeospatial.SageMakerGeospatial,
    AwsError,
    zio.aws.sagemakergeospatial.model.StartVectorEnrichmentJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startVectorEnrichmentJob(request))
  def startEarthObservationJob(request: StartEarthObservationJobRequest): ZIO[
    zio.aws.sagemakergeospatial.SageMakerGeospatial,
    AwsError,
    zio.aws.sagemakergeospatial.model.StartEarthObservationJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startEarthObservationJob(request))
  def getEarthObservationJob(request: GetEarthObservationJobRequest): ZIO[
    zio.aws.sagemakergeospatial.SageMakerGeospatial,
    AwsError,
    zio.aws.sagemakergeospatial.model.GetEarthObservationJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getEarthObservationJob(request))
  def listEarthObservationJobs(
      request: ListEarthObservationJobsRequest
  ): ZStream[
    zio.aws.sagemakergeospatial.SageMakerGeospatial,
    AwsError,
    zio.aws.sagemakergeospatial.model.ListEarthObservationJobOutputConfig.ReadOnly
  ] = ZStream.serviceWithStream(_.listEarthObservationJobs(request))
  def listEarthObservationJobsPaginated(
      request: ListEarthObservationJobsRequest
  ): ZIO[
    zio.aws.sagemakergeospatial.SageMakerGeospatial,
    AwsError,
    zio.aws.sagemakergeospatial.model.ListEarthObservationJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listEarthObservationJobsPaginated(request))
  def listRasterDataCollections(
      request: ListRasterDataCollectionsRequest
  ): ZStream[
    zio.aws.sagemakergeospatial.SageMakerGeospatial,
    AwsError,
    zio.aws.sagemakergeospatial.model.RasterDataCollectionMetadata.ReadOnly
  ] = ZStream.serviceWithStream(_.listRasterDataCollections(request))
  def listRasterDataCollectionsPaginated(
      request: ListRasterDataCollectionsRequest
  ): ZIO[
    zio.aws.sagemakergeospatial.SageMakerGeospatial,
    AwsError,
    zio.aws.sagemakergeospatial.model.ListRasterDataCollectionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRasterDataCollectionsPaginated(request))
  def deleteEarthObservationJob(request: DeleteEarthObservationJobRequest): ZIO[
    zio.aws.sagemakergeospatial.SageMakerGeospatial,
    AwsError,
    zio.aws.sagemakergeospatial.model.DeleteEarthObservationJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteEarthObservationJob(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.sagemakergeospatial.SageMakerGeospatial,
    AwsError,
    zio.aws.sagemakergeospatial.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.sagemakergeospatial.SageMakerGeospatial,
    AwsError,
    zio.aws.sagemakergeospatial.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.sagemakergeospatial.SageMakerGeospatial,
    AwsError,
    zio.aws.sagemakergeospatial.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def deleteVectorEnrichmentJob(request: DeleteVectorEnrichmentJobRequest): ZIO[
    zio.aws.sagemakergeospatial.SageMakerGeospatial,
    AwsError,
    zio.aws.sagemakergeospatial.model.DeleteVectorEnrichmentJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteVectorEnrichmentJob(request))
  def exportVectorEnrichmentJob(request: ExportVectorEnrichmentJobRequest): ZIO[
    zio.aws.sagemakergeospatial.SageMakerGeospatial,
    AwsError,
    zio.aws.sagemakergeospatial.model.ExportVectorEnrichmentJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.exportVectorEnrichmentJob(request))
  def getTile(request: GetTileRequest): ZIO[
    zio.aws.sagemakergeospatial.SageMakerGeospatial,
    AwsError,
    StreamingOutputResult[
      Any,
      zio.aws.sagemakergeospatial.model.GetTileResponse.ReadOnly,
      Byte
    ]
  ] = ZIO.serviceWithZIO(_.getTile(request))
  def listVectorEnrichmentJobs(
      request: ListVectorEnrichmentJobsRequest
  ): ZStream[
    zio.aws.sagemakergeospatial.SageMakerGeospatial,
    AwsError,
    zio.aws.sagemakergeospatial.model.ListVectorEnrichmentJobOutputConfig.ReadOnly
  ] = ZStream.serviceWithStream(_.listVectorEnrichmentJobs(request))
  def listVectorEnrichmentJobsPaginated(
      request: ListVectorEnrichmentJobsRequest
  ): ZIO[
    zio.aws.sagemakergeospatial.SageMakerGeospatial,
    AwsError,
    zio.aws.sagemakergeospatial.model.ListVectorEnrichmentJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listVectorEnrichmentJobsPaginated(request))
  def getRasterDataCollection(request: GetRasterDataCollectionRequest): ZIO[
    zio.aws.sagemakergeospatial.SageMakerGeospatial,
    AwsError,
    zio.aws.sagemakergeospatial.model.GetRasterDataCollectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRasterDataCollection(request))
  def exportEarthObservationJob(request: ExportEarthObservationJobRequest): ZIO[
    zio.aws.sagemakergeospatial.SageMakerGeospatial,
    AwsError,
    zio.aws.sagemakergeospatial.model.ExportEarthObservationJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.exportEarthObservationJob(request))
  def stopEarthObservationJob(request: StopEarthObservationJobRequest): ZIO[
    zio.aws.sagemakergeospatial.SageMakerGeospatial,
    AwsError,
    zio.aws.sagemakergeospatial.model.StopEarthObservationJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopEarthObservationJob(request))
  def searchRasterDataCollection(
      request: SearchRasterDataCollectionRequest
  ): ZIO[
    zio.aws.sagemakergeospatial.SageMakerGeospatial,
    AwsError,
    StreamingOutputResult[
      Any,
      zio.aws.sagemakergeospatial.model.SearchRasterDataCollectionResponse.ReadOnly,
      zio.aws.sagemakergeospatial.model.ItemSource.ReadOnly
    ]
  ] = ZIO.serviceWithZIO(_.searchRasterDataCollection(request))
  def searchRasterDataCollectionPaginated(
      request: SearchRasterDataCollectionRequest
  ): ZIO[
    zio.aws.sagemakergeospatial.SageMakerGeospatial,
    AwsError,
    zio.aws.sagemakergeospatial.model.SearchRasterDataCollectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchRasterDataCollectionPaginated(request))
}
