package zio.aws.sagemakergeospatial.model
import zio.aws.sagemakergeospatial.model.primitives.VectorEnrichmentJobArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class StopVectorEnrichmentJobRequest(arn: VectorEnrichmentJobArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.StopVectorEnrichmentJobRequest = {
    import StopVectorEnrichmentJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.StopVectorEnrichmentJobRequest
      .builder()
      .arn(VectorEnrichmentJobArn.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.StopVectorEnrichmentJobRequest.ReadOnly =
    zio.aws.sagemakergeospatial.model.StopVectorEnrichmentJobRequest
      .wrap(buildAwsValue())
}
object StopVectorEnrichmentJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.StopVectorEnrichmentJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakergeospatial.model.StopVectorEnrichmentJobRequest =
      zio.aws.sagemakergeospatial.model.StopVectorEnrichmentJobRequest(arn)
    def arn: VectorEnrichmentJobArn
    def getArn: ZIO[Any, Nothing, VectorEnrichmentJobArn] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.StopVectorEnrichmentJobRequest
  ) extends zio.aws.sagemakergeospatial.model.StopVectorEnrichmentJobRequest.ReadOnly {
    override val arn: VectorEnrichmentJobArn =
      zio.aws.sagemakergeospatial.model.primitives
        .VectorEnrichmentJobArn(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.StopVectorEnrichmentJobRequest
  ): zio.aws.sagemakergeospatial.model.StopVectorEnrichmentJobRequest.ReadOnly =
    new Wrapper(impl)
}
