package zio.aws.sagemakergeospatial.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sagemakergeospatial.model.primitives.{
  NextToken,
  ListVectorEnrichmentJobInputMaxResultsInteger
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListVectorEnrichmentJobsRequest(
    maxResults: Optional[ListVectorEnrichmentJobInputMaxResultsInteger] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    sortBy: Optional[String] = Optional.Absent,
    sortOrder: Optional[zio.aws.sagemakergeospatial.model.SortOrder] =
      Optional.Absent,
    statusEquals: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.ListVectorEnrichmentJobsRequest = {
    import ListVectorEnrichmentJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.ListVectorEnrichmentJobsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListVectorEnrichmentJobInputMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(sortBy.map(value => value: java.lang.String))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(statusEquals.map(value => value: java.lang.String))(
        _.statusEquals
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.ListVectorEnrichmentJobsRequest.ReadOnly =
    zio.aws.sagemakergeospatial.model.ListVectorEnrichmentJobsRequest
      .wrap(buildAwsValue())
}
object ListVectorEnrichmentJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.ListVectorEnrichmentJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakergeospatial.model.ListVectorEnrichmentJobsRequest =
      zio.aws.sagemakergeospatial.model.ListVectorEnrichmentJobsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value),
        statusEquals.map(value => value)
      )
    def maxResults: Optional[ListVectorEnrichmentJobInputMaxResultsInteger]
    def nextToken: Optional[NextToken]
    def sortBy: Optional[String]
    def sortOrder: Optional[zio.aws.sagemakergeospatial.model.SortOrder]
    def statusEquals: Optional[String]
    def getMaxResults
        : ZIO[Any, AwsError, ListVectorEnrichmentJobInputMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSortBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder
        : ZIO[Any, AwsError, zio.aws.sagemakergeospatial.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getStatusEquals: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusEquals", statusEquals)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.ListVectorEnrichmentJobsRequest
  ) extends zio.aws.sagemakergeospatial.model.ListVectorEnrichmentJobsRequest.ReadOnly {
    override val maxResults
        : Optional[ListVectorEnrichmentJobInputMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.sagemakergeospatial.model.primitives
            .ListVectorEnrichmentJobInputMaxResultsInteger(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.sagemakergeospatial.model.primitives.NextToken(value)
      )
    override val sortBy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sortBy())
      .map(value => value: String)
    override val sortOrder
        : Optional[zio.aws.sagemakergeospatial.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.sagemakergeospatial.model.SortOrder.wrap(value))
    override val statusEquals: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusEquals())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.ListVectorEnrichmentJobsRequest
  ): zio.aws.sagemakergeospatial.model.ListVectorEnrichmentJobsRequest.ReadOnly =
    new Wrapper(impl)
}
