package zio.aws.sagemakergeospatial.model
import zio.aws.sagemakergeospatial.model.primitives.DataCollectionArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetRasterDataCollectionResponse(
    arn: DataCollectionArn,
    description: String,
    descriptionPageUrl: String,
    imageSourceBands: Iterable[String],
    name: String,
    supportedFilters: Iterable[zio.aws.sagemakergeospatial.model.Filter],
    tags: Optional[Map[String, String]] = Optional.Absent,
    `type`: zio.aws.sagemakergeospatial.model.DataCollectionType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.GetRasterDataCollectionResponse = {
    import GetRasterDataCollectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.GetRasterDataCollectionResponse
      .builder()
      .arn(DataCollectionArn.unwrap(arn): java.lang.String)
      .description(description: java.lang.String)
      .descriptionPageUrl(descriptionPageUrl: java.lang.String)
      .imageSourceBands(imageSourceBands.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .name(name: java.lang.String)
      .supportedFilters(supportedFilters.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.GetRasterDataCollectionResponse.ReadOnly =
    zio.aws.sagemakergeospatial.model.GetRasterDataCollectionResponse
      .wrap(buildAwsValue())
}
object GetRasterDataCollectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.GetRasterDataCollectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakergeospatial.model.GetRasterDataCollectionResponse =
      zio.aws.sagemakergeospatial.model.GetRasterDataCollectionResponse(
        arn,
        description,
        descriptionPageUrl,
        imageSourceBands,
        name,
        supportedFilters.map { item =>
          item.asEditable
        },
        tags.map(value => value),
        `type`
      )
    def arn: DataCollectionArn
    def description: String
    def descriptionPageUrl: String
    def imageSourceBands: List[String]
    def name: String
    def supportedFilters
        : List[zio.aws.sagemakergeospatial.model.Filter.ReadOnly]
    def tags: Optional[Map[String, String]]
    def `type`: zio.aws.sagemakergeospatial.model.DataCollectionType
    def getArn: ZIO[Any, Nothing, DataCollectionArn] = ZIO.succeed(arn)
    def getDescription: ZIO[Any, Nothing, String] = ZIO.succeed(description)
    def getDescriptionPageUrl: ZIO[Any, Nothing, String] =
      ZIO.succeed(descriptionPageUrl)
    def getImageSourceBands: ZIO[Any, Nothing, List[String]] =
      ZIO.succeed(imageSourceBands)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getSupportedFilters: ZIO[Any, Nothing, List[
      zio.aws.sagemakergeospatial.model.Filter.ReadOnly
    ]] = ZIO.succeed(supportedFilters)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
    def getType: ZIO[
      Any,
      Nothing,
      zio.aws.sagemakergeospatial.model.DataCollectionType
    ] = ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.GetRasterDataCollectionResponse
  ) extends zio.aws.sagemakergeospatial.model.GetRasterDataCollectionResponse.ReadOnly {
    override val arn: DataCollectionArn =
      zio.aws.sagemakergeospatial.model.primitives.DataCollectionArn(impl.arn())
    override val description: String = impl.description(): String
    override val descriptionPageUrl: String = impl.descriptionPageUrl(): String
    override val imageSourceBands: List[String] = impl
      .imageSourceBands()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val name: String = impl.name(): String
    override val supportedFilters
        : List[zio.aws.sagemakergeospatial.model.Filter.ReadOnly] = impl
      .supportedFilters()
      .asScala
      .map { item =>
        zio.aws.sagemakergeospatial.model.Filter.wrap(item)
      }
      .toList
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val `type`: zio.aws.sagemakergeospatial.model.DataCollectionType =
      zio.aws.sagemakergeospatial.model.DataCollectionType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.GetRasterDataCollectionResponse
  ): zio.aws.sagemakergeospatial.model.GetRasterDataCollectionResponse.ReadOnly =
    new Wrapper(impl)
}
