package zio.aws.sagemakergeospatial.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ViewSunAzimuthInput(lowerBound: Float, upperBound: Float) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.ViewSunAzimuthInput = {
    import ViewSunAzimuthInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.ViewSunAzimuthInput
      .builder()
      .lowerBound(lowerBound: java.lang.Float)
      .upperBound(upperBound: java.lang.Float)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.ViewSunAzimuthInput.ReadOnly =
    zio.aws.sagemakergeospatial.model.ViewSunAzimuthInput.wrap(buildAwsValue())
}
object ViewSunAzimuthInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.ViewSunAzimuthInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakergeospatial.model.ViewSunAzimuthInput =
      zio.aws.sagemakergeospatial.model
        .ViewSunAzimuthInput(lowerBound, upperBound)
    def lowerBound: Float
    def upperBound: Float
    def getLowerBound: ZIO[Any, Nothing, Float] = ZIO.succeed(lowerBound)
    def getUpperBound: ZIO[Any, Nothing, Float] = ZIO.succeed(upperBound)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.ViewSunAzimuthInput
  ) extends zio.aws.sagemakergeospatial.model.ViewSunAzimuthInput.ReadOnly {
    override val lowerBound: Float = impl.lowerBound(): Float
    override val upperBound: Float = impl.upperBound(): Float
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.ViewSunAzimuthInput
  ): zio.aws.sagemakergeospatial.model.ViewSunAzimuthInput.ReadOnly =
    new Wrapper(impl)
}
