package zio.aws.sagemakergeospatial.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RasterDataCollectionQueryWithBandFilterInput(
    areaOfInterest: Optional[zio.aws.sagemakergeospatial.model.AreaOfInterest] =
      Optional.Absent,
    bandFilter: Optional[Iterable[String]] = Optional.Absent,
    propertyFilters: Optional[
      zio.aws.sagemakergeospatial.model.PropertyFilters
    ] = Optional.Absent,
    timeRangeFilter: zio.aws.sagemakergeospatial.model.TimeRangeFilterInput
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.RasterDataCollectionQueryWithBandFilterInput = {
    import RasterDataCollectionQueryWithBandFilterInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.RasterDataCollectionQueryWithBandFilterInput
      .builder()
      .optionallyWith(areaOfInterest.map(value => value.buildAwsValue()))(
        _.areaOfInterest
      )
      .optionallyWith(
        bandFilter.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.bandFilter)
      .optionallyWith(propertyFilters.map(value => value.buildAwsValue()))(
        _.propertyFilters
      )
      .timeRangeFilter(timeRangeFilter.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.RasterDataCollectionQueryWithBandFilterInput.ReadOnly =
    zio.aws.sagemakergeospatial.model.RasterDataCollectionQueryWithBandFilterInput
      .wrap(buildAwsValue())
}
object RasterDataCollectionQueryWithBandFilterInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.RasterDataCollectionQueryWithBandFilterInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakergeospatial.model.RasterDataCollectionQueryWithBandFilterInput =
      zio.aws.sagemakergeospatial.model
        .RasterDataCollectionQueryWithBandFilterInput(
          areaOfInterest.map(value => value.asEditable),
          bandFilter.map(value => value),
          propertyFilters.map(value => value.asEditable),
          timeRangeFilter.asEditable
        )
    def areaOfInterest
        : Optional[zio.aws.sagemakergeospatial.model.AreaOfInterest.ReadOnly]
    def bandFilter: Optional[List[String]]
    def propertyFilters
        : Optional[zio.aws.sagemakergeospatial.model.PropertyFilters.ReadOnly]
    def timeRangeFilter
        : zio.aws.sagemakergeospatial.model.TimeRangeFilterInput.ReadOnly
    def getAreaOfInterest: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.AreaOfInterest.ReadOnly
    ] = AwsError.unwrapOptionField("areaOfInterest", areaOfInterest)
    def getBandFilter: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("bandFilter", bandFilter)
    def getPropertyFilters: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.PropertyFilters.ReadOnly
    ] = AwsError.unwrapOptionField("propertyFilters", propertyFilters)
    def getTimeRangeFilter: ZIO[
      Any,
      Nothing,
      zio.aws.sagemakergeospatial.model.TimeRangeFilterInput.ReadOnly
    ] = ZIO.succeed(timeRangeFilter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.RasterDataCollectionQueryWithBandFilterInput
  ) extends zio.aws.sagemakergeospatial.model.RasterDataCollectionQueryWithBandFilterInput.ReadOnly {
    override val areaOfInterest
        : Optional[zio.aws.sagemakergeospatial.model.AreaOfInterest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.areaOfInterest())
        .map(value =>
          zio.aws.sagemakergeospatial.model.AreaOfInterest.wrap(value)
        )
    override val bandFilter: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.bandFilter())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val propertyFilters
        : Optional[zio.aws.sagemakergeospatial.model.PropertyFilters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.propertyFilters())
        .map(value =>
          zio.aws.sagemakergeospatial.model.PropertyFilters.wrap(value)
        )
    override val timeRangeFilter
        : zio.aws.sagemakergeospatial.model.TimeRangeFilterInput.ReadOnly =
      zio.aws.sagemakergeospatial.model.TimeRangeFilterInput
        .wrap(impl.timeRangeFilter())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.RasterDataCollectionQueryWithBandFilterInput
  ): zio.aws.sagemakergeospatial.model.RasterDataCollectionQueryWithBandFilterInput.ReadOnly =
    new Wrapper(impl)
}
