package zio.aws.sagemakergeospatial.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class OutputBand(
    bandName: String,
    outputDataType: zio.aws.sagemakergeospatial.model.OutputType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.OutputBand = {
    import OutputBand.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.OutputBand
      .builder()
      .bandName(bandName: java.lang.String)
      .outputDataType(outputDataType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.sagemakergeospatial.model.OutputBand.ReadOnly =
    zio.aws.sagemakergeospatial.model.OutputBand.wrap(buildAwsValue())
}
object OutputBand {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.OutputBand
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakergeospatial.model.OutputBand =
      zio.aws.sagemakergeospatial.model.OutputBand(bandName, outputDataType)
    def bandName: String
    def outputDataType: zio.aws.sagemakergeospatial.model.OutputType
    def getBandName: ZIO[Any, Nothing, String] = ZIO.succeed(bandName)
    def getOutputDataType
        : ZIO[Any, Nothing, zio.aws.sagemakergeospatial.model.OutputType] =
      ZIO.succeed(outputDataType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.OutputBand
  ) extends zio.aws.sagemakergeospatial.model.OutputBand.ReadOnly {
    override val bandName: String = impl.bandName(): String
    override val outputDataType: zio.aws.sagemakergeospatial.model.OutputType =
      zio.aws.sagemakergeospatial.model.OutputType.wrap(impl.outputDataType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.OutputBand
  ): zio.aws.sagemakergeospatial.model.OutputBand.ReadOnly = new Wrapper(impl)
}
