package zio.aws.sagemakergeospatial.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class JobConfigInput(
    bandMathConfig: Optional[
      zio.aws.sagemakergeospatial.model.BandMathConfigInput
    ] = Optional.Absent,
    cloudMaskingConfig: Optional[
      zio.aws.sagemakergeospatial.model.CloudMaskingConfigInput
    ] = Optional.Absent,
    cloudRemovalConfig: Optional[
      zio.aws.sagemakergeospatial.model.CloudRemovalConfigInput
    ] = Optional.Absent,
    geoMosaicConfig: Optional[
      zio.aws.sagemakergeospatial.model.GeoMosaicConfigInput
    ] = Optional.Absent,
    landCoverSegmentationConfig: Optional[
      zio.aws.sagemakergeospatial.model.LandCoverSegmentationConfigInput
    ] = Optional.Absent,
    resamplingConfig: Optional[
      zio.aws.sagemakergeospatial.model.ResamplingConfigInput
    ] = Optional.Absent,
    stackConfig: Optional[zio.aws.sagemakergeospatial.model.StackConfigInput] =
      Optional.Absent,
    temporalStatisticsConfig: Optional[
      zio.aws.sagemakergeospatial.model.TemporalStatisticsConfigInput
    ] = Optional.Absent,
    zonalStatisticsConfig: Optional[
      zio.aws.sagemakergeospatial.model.ZonalStatisticsConfigInput
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.JobConfigInput = {
    import JobConfigInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.JobConfigInput
      .builder()
      .optionallyWith(bandMathConfig.map(value => value.buildAwsValue()))(
        _.bandMathConfig
      )
      .optionallyWith(cloudMaskingConfig.map(value => value.buildAwsValue()))(
        _.cloudMaskingConfig
      )
      .optionallyWith(cloudRemovalConfig.map(value => value.buildAwsValue()))(
        _.cloudRemovalConfig
      )
      .optionallyWith(geoMosaicConfig.map(value => value.buildAwsValue()))(
        _.geoMosaicConfig
      )
      .optionallyWith(
        landCoverSegmentationConfig.map(value => value.buildAwsValue())
      )(_.landCoverSegmentationConfig)
      .optionallyWith(resamplingConfig.map(value => value.buildAwsValue()))(
        _.resamplingConfig
      )
      .optionallyWith(stackConfig.map(value => value.buildAwsValue()))(
        _.stackConfig
      )
      .optionallyWith(
        temporalStatisticsConfig.map(value => value.buildAwsValue())
      )(_.temporalStatisticsConfig)
      .optionallyWith(
        zonalStatisticsConfig.map(value => value.buildAwsValue())
      )(_.zonalStatisticsConfig)
      .build()
  }
  def asReadOnly: zio.aws.sagemakergeospatial.model.JobConfigInput.ReadOnly =
    zio.aws.sagemakergeospatial.model.JobConfigInput.wrap(buildAwsValue())
}
object JobConfigInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.JobConfigInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakergeospatial.model.JobConfigInput =
      zio.aws.sagemakergeospatial.model.JobConfigInput(
        bandMathConfig.map(value => value.asEditable),
        cloudMaskingConfig.map(value => value.asEditable),
        cloudRemovalConfig.map(value => value.asEditable),
        geoMosaicConfig.map(value => value.asEditable),
        landCoverSegmentationConfig.map(value => value.asEditable),
        resamplingConfig.map(value => value.asEditable),
        stackConfig.map(value => value.asEditable),
        temporalStatisticsConfig.map(value => value.asEditable),
        zonalStatisticsConfig.map(value => value.asEditable)
      )
    def bandMathConfig: Optional[
      zio.aws.sagemakergeospatial.model.BandMathConfigInput.ReadOnly
    ]
    def cloudMaskingConfig: Optional[
      zio.aws.sagemakergeospatial.model.CloudMaskingConfigInput.ReadOnly
    ]
    def cloudRemovalConfig: Optional[
      zio.aws.sagemakergeospatial.model.CloudRemovalConfigInput.ReadOnly
    ]
    def geoMosaicConfig: Optional[
      zio.aws.sagemakergeospatial.model.GeoMosaicConfigInput.ReadOnly
    ]
    def landCoverSegmentationConfig: Optional[
      zio.aws.sagemakergeospatial.model.LandCoverSegmentationConfigInput.ReadOnly
    ]
    def resamplingConfig: Optional[
      zio.aws.sagemakergeospatial.model.ResamplingConfigInput.ReadOnly
    ]
    def stackConfig
        : Optional[zio.aws.sagemakergeospatial.model.StackConfigInput.ReadOnly]
    def temporalStatisticsConfig: Optional[
      zio.aws.sagemakergeospatial.model.TemporalStatisticsConfigInput.ReadOnly
    ]
    def zonalStatisticsConfig: Optional[
      zio.aws.sagemakergeospatial.model.ZonalStatisticsConfigInput.ReadOnly
    ]
    def getBandMathConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.BandMathConfigInput.ReadOnly
    ] = AwsError.unwrapOptionField("bandMathConfig", bandMathConfig)
    def getCloudMaskingConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.CloudMaskingConfigInput.ReadOnly
    ] = AwsError.unwrapOptionField("cloudMaskingConfig", cloudMaskingConfig)
    def getCloudRemovalConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.CloudRemovalConfigInput.ReadOnly
    ] = AwsError.unwrapOptionField("cloudRemovalConfig", cloudRemovalConfig)
    def getGeoMosaicConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.GeoMosaicConfigInput.ReadOnly
    ] = AwsError.unwrapOptionField("geoMosaicConfig", geoMosaicConfig)
    def getLandCoverSegmentationConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.LandCoverSegmentationConfigInput.ReadOnly
    ] = AwsError.unwrapOptionField(
      "landCoverSegmentationConfig",
      landCoverSegmentationConfig
    )
    def getResamplingConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.ResamplingConfigInput.ReadOnly
    ] = AwsError.unwrapOptionField("resamplingConfig", resamplingConfig)
    def getStackConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.StackConfigInput.ReadOnly
    ] = AwsError.unwrapOptionField("stackConfig", stackConfig)
    def getTemporalStatisticsConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.TemporalStatisticsConfigInput.ReadOnly
    ] = AwsError.unwrapOptionField(
      "temporalStatisticsConfig",
      temporalStatisticsConfig
    )
    def getZonalStatisticsConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.ZonalStatisticsConfigInput.ReadOnly
    ] =
      AwsError.unwrapOptionField("zonalStatisticsConfig", zonalStatisticsConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.JobConfigInput
  ) extends zio.aws.sagemakergeospatial.model.JobConfigInput.ReadOnly {
    override val bandMathConfig: Optional[
      zio.aws.sagemakergeospatial.model.BandMathConfigInput.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.bandMathConfig())
      .map(value =>
        zio.aws.sagemakergeospatial.model.BandMathConfigInput.wrap(value)
      )
    override val cloudMaskingConfig: Optional[
      zio.aws.sagemakergeospatial.model.CloudMaskingConfigInput.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.cloudMaskingConfig())
      .map(value =>
        zio.aws.sagemakergeospatial.model.CloudMaskingConfigInput.wrap(value)
      )
    override val cloudRemovalConfig: Optional[
      zio.aws.sagemakergeospatial.model.CloudRemovalConfigInput.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.cloudRemovalConfig())
      .map(value =>
        zio.aws.sagemakergeospatial.model.CloudRemovalConfigInput.wrap(value)
      )
    override val geoMosaicConfig: Optional[
      zio.aws.sagemakergeospatial.model.GeoMosaicConfigInput.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.geoMosaicConfig())
      .map(value =>
        zio.aws.sagemakergeospatial.model.GeoMosaicConfigInput.wrap(value)
      )
    override val landCoverSegmentationConfig: Optional[
      zio.aws.sagemakergeospatial.model.LandCoverSegmentationConfigInput.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.landCoverSegmentationConfig())
      .map(value =>
        zio.aws.sagemakergeospatial.model.LandCoverSegmentationConfigInput
          .wrap(value)
      )
    override val resamplingConfig: Optional[
      zio.aws.sagemakergeospatial.model.ResamplingConfigInput.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.resamplingConfig())
      .map(value =>
        zio.aws.sagemakergeospatial.model.ResamplingConfigInput.wrap(value)
      )
    override val stackConfig: Optional[
      zio.aws.sagemakergeospatial.model.StackConfigInput.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.stackConfig())
      .map(value =>
        zio.aws.sagemakergeospatial.model.StackConfigInput.wrap(value)
      )
    override val temporalStatisticsConfig: Optional[
      zio.aws.sagemakergeospatial.model.TemporalStatisticsConfigInput.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.temporalStatisticsConfig())
      .map(value =>
        zio.aws.sagemakergeospatial.model.TemporalStatisticsConfigInput
          .wrap(value)
      )
    override val zonalStatisticsConfig: Optional[
      zio.aws.sagemakergeospatial.model.ZonalStatisticsConfigInput.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.zonalStatisticsConfig())
      .map(value =>
        zio.aws.sagemakergeospatial.model.ZonalStatisticsConfigInput.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.JobConfigInput
  ): zio.aws.sagemakergeospatial.model.JobConfigInput.ReadOnly = new Wrapper(
    impl
  )
}
