package zio.aws.sagemakergeospatial.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class VectorEnrichmentJobDataSourceConfigInput(
    s3Data: Optional[
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobS3Data
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.VectorEnrichmentJobDataSourceConfigInput = {
    import VectorEnrichmentJobDataSourceConfigInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.VectorEnrichmentJobDataSourceConfigInput
      .builder()
      .optionallyWith(s3Data.map(value => value.buildAwsValue()))(_.s3Data)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.VectorEnrichmentJobDataSourceConfigInput.ReadOnly =
    zio.aws.sagemakergeospatial.model.VectorEnrichmentJobDataSourceConfigInput
      .wrap(buildAwsValue())
}
object VectorEnrichmentJobDataSourceConfigInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.VectorEnrichmentJobDataSourceConfigInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakergeospatial.model.VectorEnrichmentJobDataSourceConfigInput =
      zio.aws.sagemakergeospatial.model
        .VectorEnrichmentJobDataSourceConfigInput(
          s3Data.map(value => value.asEditable)
        )
    def s3Data: Optional[
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobS3Data.ReadOnly
    ]
    def getS3Data: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobS3Data.ReadOnly
    ] = AwsError.unwrapOptionField("s3Data", s3Data)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.VectorEnrichmentJobDataSourceConfigInput
  ) extends zio.aws.sagemakergeospatial.model.VectorEnrichmentJobDataSourceConfigInput.ReadOnly {
    override val s3Data: Optional[
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobS3Data.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Data())
      .map(value =>
        zio.aws.sagemakergeospatial.model.VectorEnrichmentJobS3Data.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.VectorEnrichmentJobDataSourceConfigInput
  ): zio.aws.sagemakergeospatial.model.VectorEnrichmentJobDataSourceConfigInput.ReadOnly =
    new Wrapper(impl)
}
