package zio.aws.sagemakergeospatial.model
import zio.aws.sagemakergeospatial.model.primitives.SyntheticTimestamp_date_time
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class TimeRangeFilterOutput(
    endTime: SyntheticTimestamp_date_time,
    startTime: SyntheticTimestamp_date_time
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.TimeRangeFilterOutput = {
    import TimeRangeFilterOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.TimeRangeFilterOutput
      .builder()
      .endTime(SyntheticTimestamp_date_time.unwrap(endTime): Instant)
      .startTime(SyntheticTimestamp_date_time.unwrap(startTime): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.TimeRangeFilterOutput.ReadOnly =
    zio.aws.sagemakergeospatial.model.TimeRangeFilterOutput
      .wrap(buildAwsValue())
}
object TimeRangeFilterOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.TimeRangeFilterOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakergeospatial.model.TimeRangeFilterOutput =
      zio.aws.sagemakergeospatial.model
        .TimeRangeFilterOutput(endTime, startTime)
    def endTime: SyntheticTimestamp_date_time
    def startTime: SyntheticTimestamp_date_time
    def getEndTime: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(endTime)
    def getStartTime: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(startTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.TimeRangeFilterOutput
  ) extends zio.aws.sagemakergeospatial.model.TimeRangeFilterOutput.ReadOnly {
    override val endTime: SyntheticTimestamp_date_time =
      zio.aws.sagemakergeospatial.model.primitives
        .SyntheticTimestamp_date_time(impl.endTime())
    override val startTime: SyntheticTimestamp_date_time =
      zio.aws.sagemakergeospatial.model.primitives
        .SyntheticTimestamp_date_time(impl.startTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.TimeRangeFilterOutput
  ): zio.aws.sagemakergeospatial.model.TimeRangeFilterOutput.ReadOnly =
    new Wrapper(impl)
}
