package zio.aws.sagemakergeospatial.model
import zio.aws.sagemakergeospatial.model.primitives.{
  StartEarthObservationJobInputNameString,
  KmsKey,
  ExecutionRoleArn,
  StartEarthObservationJobInputClientTokenString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StartEarthObservationJobRequest(
    clientToken: Optional[StartEarthObservationJobInputClientTokenString] =
      Optional.Absent,
    executionRoleArn: Optional[ExecutionRoleArn] = Optional.Absent,
    inputConfig: zio.aws.sagemakergeospatial.model.InputConfigInput,
    jobConfig: zio.aws.sagemakergeospatial.model.JobConfigInput,
    kmsKeyId: Optional[KmsKey] = Optional.Absent,
    name: StartEarthObservationJobInputNameString,
    tags: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.StartEarthObservationJobRequest = {
    import StartEarthObservationJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.StartEarthObservationJobRequest
      .builder()
      .optionallyWith(
        clientToken.map(value =>
          StartEarthObservationJobInputClientTokenString.unwrap(
            value
          ): java.lang.String
        )
      )(_.clientToken)
      .optionallyWith(
        executionRoleArn.map(value =>
          ExecutionRoleArn.unwrap(value): java.lang.String
        )
      )(_.executionRoleArn)
      .inputConfig(inputConfig.buildAwsValue())
      .jobConfig(jobConfig.buildAwsValue())
      .optionallyWith(
        kmsKeyId.map(value => KmsKey.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .name(
        StartEarthObservationJobInputNameString.unwrap(name): java.lang.String
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.StartEarthObservationJobRequest.ReadOnly =
    zio.aws.sagemakergeospatial.model.StartEarthObservationJobRequest
      .wrap(buildAwsValue())
}
object StartEarthObservationJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.StartEarthObservationJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakergeospatial.model.StartEarthObservationJobRequest =
      zio.aws.sagemakergeospatial.model.StartEarthObservationJobRequest(
        clientToken.map(value => value),
        executionRoleArn.map(value => value),
        inputConfig.asEditable,
        jobConfig.asEditable,
        kmsKeyId.map(value => value),
        name,
        tags.map(value => value)
      )
    def clientToken: Optional[StartEarthObservationJobInputClientTokenString]
    def executionRoleArn: Optional[ExecutionRoleArn]
    def inputConfig: zio.aws.sagemakergeospatial.model.InputConfigInput.ReadOnly
    def jobConfig: zio.aws.sagemakergeospatial.model.JobConfigInput.ReadOnly
    def kmsKeyId: Optional[KmsKey]
    def name: StartEarthObservationJobInputNameString
    def tags: Optional[Map[String, String]]
    def getClientToken
        : ZIO[Any, AwsError, StartEarthObservationJobInputClientTokenString] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getExecutionRoleArn: ZIO[Any, AwsError, ExecutionRoleArn] =
      AwsError.unwrapOptionField("executionRoleArn", executionRoleArn)
    def getInputConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemakergeospatial.model.InputConfigInput.ReadOnly
    ] = ZIO.succeed(inputConfig)
    def getJobConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemakergeospatial.model.JobConfigInput.ReadOnly
    ] = ZIO.succeed(jobConfig)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKey] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getName: ZIO[Any, Nothing, StartEarthObservationJobInputNameString] =
      ZIO.succeed(name)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.StartEarthObservationJobRequest
  ) extends zio.aws.sagemakergeospatial.model.StartEarthObservationJobRequest.ReadOnly {
    override val clientToken
        : Optional[StartEarthObservationJobInputClientTokenString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientToken())
        .map(value =>
          zio.aws.sagemakergeospatial.model.primitives
            .StartEarthObservationJobInputClientTokenString(value)
        )
    override val executionRoleArn: Optional[ExecutionRoleArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionRoleArn())
        .map(value =>
          zio.aws.sagemakergeospatial.model.primitives.ExecutionRoleArn(value)
        )
    override val inputConfig
        : zio.aws.sagemakergeospatial.model.InputConfigInput.ReadOnly =
      zio.aws.sagemakergeospatial.model.InputConfigInput
        .wrap(impl.inputConfig())
    override val jobConfig
        : zio.aws.sagemakergeospatial.model.JobConfigInput.ReadOnly =
      zio.aws.sagemakergeospatial.model.JobConfigInput.wrap(impl.jobConfig())
    override val kmsKeyId: Optional[KmsKey] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.sagemakergeospatial.model.primitives.KmsKey(value))
    override val name: StartEarthObservationJobInputNameString =
      zio.aws.sagemakergeospatial.model.primitives
        .StartEarthObservationJobInputNameString(impl.name())
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.StartEarthObservationJobRequest
  ): zio.aws.sagemakergeospatial.model.StartEarthObservationJobRequest.ReadOnly =
    new Wrapper(impl)
}
