package zio.aws.sagemakergeospatial.model
import zio.aws.sagemakergeospatial.model.primitives.DataCollectionArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RasterDataCollectionQueryOutput(
    areaOfInterest: Optional[zio.aws.sagemakergeospatial.model.AreaOfInterest] =
      Optional.Absent,
    propertyFilters: Optional[
      zio.aws.sagemakergeospatial.model.PropertyFilters
    ] = Optional.Absent,
    rasterDataCollectionArn: DataCollectionArn,
    rasterDataCollectionName: String,
    timeRangeFilter: zio.aws.sagemakergeospatial.model.TimeRangeFilterOutput
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.RasterDataCollectionQueryOutput = {
    import RasterDataCollectionQueryOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.RasterDataCollectionQueryOutput
      .builder()
      .optionallyWith(areaOfInterest.map(value => value.buildAwsValue()))(
        _.areaOfInterest
      )
      .optionallyWith(propertyFilters.map(value => value.buildAwsValue()))(
        _.propertyFilters
      )
      .rasterDataCollectionArn(
        DataCollectionArn.unwrap(rasterDataCollectionArn): java.lang.String
      )
      .rasterDataCollectionName(rasterDataCollectionName: java.lang.String)
      .timeRangeFilter(timeRangeFilter.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.RasterDataCollectionQueryOutput.ReadOnly =
    zio.aws.sagemakergeospatial.model.RasterDataCollectionQueryOutput
      .wrap(buildAwsValue())
}
object RasterDataCollectionQueryOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.RasterDataCollectionQueryOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakergeospatial.model.RasterDataCollectionQueryOutput =
      zio.aws.sagemakergeospatial.model.RasterDataCollectionQueryOutput(
        areaOfInterest.map(value => value.asEditable),
        propertyFilters.map(value => value.asEditable),
        rasterDataCollectionArn,
        rasterDataCollectionName,
        timeRangeFilter.asEditable
      )
    def areaOfInterest
        : Optional[zio.aws.sagemakergeospatial.model.AreaOfInterest.ReadOnly]
    def propertyFilters
        : Optional[zio.aws.sagemakergeospatial.model.PropertyFilters.ReadOnly]
    def rasterDataCollectionArn: DataCollectionArn
    def rasterDataCollectionName: String
    def timeRangeFilter
        : zio.aws.sagemakergeospatial.model.TimeRangeFilterOutput.ReadOnly
    def getAreaOfInterest: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.AreaOfInterest.ReadOnly
    ] = AwsError.unwrapOptionField("areaOfInterest", areaOfInterest)
    def getPropertyFilters: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.PropertyFilters.ReadOnly
    ] = AwsError.unwrapOptionField("propertyFilters", propertyFilters)
    def getRasterDataCollectionArn: ZIO[Any, Nothing, DataCollectionArn] =
      ZIO.succeed(rasterDataCollectionArn)
    def getRasterDataCollectionName: ZIO[Any, Nothing, String] =
      ZIO.succeed(rasterDataCollectionName)
    def getTimeRangeFilter: ZIO[
      Any,
      Nothing,
      zio.aws.sagemakergeospatial.model.TimeRangeFilterOutput.ReadOnly
    ] = ZIO.succeed(timeRangeFilter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.RasterDataCollectionQueryOutput
  ) extends zio.aws.sagemakergeospatial.model.RasterDataCollectionQueryOutput.ReadOnly {
    override val areaOfInterest
        : Optional[zio.aws.sagemakergeospatial.model.AreaOfInterest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.areaOfInterest())
        .map(value =>
          zio.aws.sagemakergeospatial.model.AreaOfInterest.wrap(value)
        )
    override val propertyFilters
        : Optional[zio.aws.sagemakergeospatial.model.PropertyFilters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.propertyFilters())
        .map(value =>
          zio.aws.sagemakergeospatial.model.PropertyFilters.wrap(value)
        )
    override val rasterDataCollectionArn: DataCollectionArn =
      zio.aws.sagemakergeospatial.model.primitives
        .DataCollectionArn(impl.rasterDataCollectionArn())
    override val rasterDataCollectionName: String =
      impl.rasterDataCollectionName(): String
    override val timeRangeFilter
        : zio.aws.sagemakergeospatial.model.TimeRangeFilterOutput.ReadOnly =
      zio.aws.sagemakergeospatial.model.TimeRangeFilterOutput
        .wrap(impl.timeRangeFilter())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.RasterDataCollectionQueryOutput
  ): zio.aws.sagemakergeospatial.model.RasterDataCollectionQueryOutput.ReadOnly =
    new Wrapper(impl)
}
