package zio.aws.sagemakergeospatial.model
import zio.aws.sagemakergeospatial.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListRasterDataCollectionsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    rasterDataCollectionSummaries: Iterable[
      zio.aws.sagemakergeospatial.model.RasterDataCollectionMetadata
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.ListRasterDataCollectionsResponse = {
    import ListRasterDataCollectionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.ListRasterDataCollectionsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .rasterDataCollectionSummaries(rasterDataCollectionSummaries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.ListRasterDataCollectionsResponse.ReadOnly =
    zio.aws.sagemakergeospatial.model.ListRasterDataCollectionsResponse
      .wrap(buildAwsValue())
}
object ListRasterDataCollectionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.ListRasterDataCollectionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakergeospatial.model.ListRasterDataCollectionsResponse =
      zio.aws.sagemakergeospatial.model.ListRasterDataCollectionsResponse(
        nextToken.map(value => value),
        rasterDataCollectionSummaries.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[NextToken]
    def rasterDataCollectionSummaries: List[
      zio.aws.sagemakergeospatial.model.RasterDataCollectionMetadata.ReadOnly
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRasterDataCollectionSummaries: ZIO[Any, Nothing, List[
      zio.aws.sagemakergeospatial.model.RasterDataCollectionMetadata.ReadOnly
    ]] = ZIO.succeed(rasterDataCollectionSummaries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.ListRasterDataCollectionsResponse
  ) extends zio.aws.sagemakergeospatial.model.ListRasterDataCollectionsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.sagemakergeospatial.model.primitives.NextToken(value)
      )
    override val rasterDataCollectionSummaries: List[
      zio.aws.sagemakergeospatial.model.RasterDataCollectionMetadata.ReadOnly
    ] = impl
      .rasterDataCollectionSummaries()
      .asScala
      .map { item =>
        zio.aws.sagemakergeospatial.model.RasterDataCollectionMetadata
          .wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.ListRasterDataCollectionsResponse
  ): zio.aws.sagemakergeospatial.model.ListRasterDataCollectionsResponse.ReadOnly =
    new Wrapper(impl)
}
