package zio.aws.sagemakergeospatial.model
import zio.aws.sagemakergeospatial.model.primitives.VectorEnrichmentJobArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetVectorEnrichmentJobRequest(arn: VectorEnrichmentJobArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.GetVectorEnrichmentJobRequest = {
    import GetVectorEnrichmentJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.GetVectorEnrichmentJobRequest
      .builder()
      .arn(VectorEnrichmentJobArn.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.GetVectorEnrichmentJobRequest.ReadOnly =
    zio.aws.sagemakergeospatial.model.GetVectorEnrichmentJobRequest
      .wrap(buildAwsValue())
}
object GetVectorEnrichmentJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.GetVectorEnrichmentJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakergeospatial.model.GetVectorEnrichmentJobRequest =
      zio.aws.sagemakergeospatial.model.GetVectorEnrichmentJobRequest(arn)
    def arn: VectorEnrichmentJobArn
    def getArn: ZIO[Any, Nothing, VectorEnrichmentJobArn] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.GetVectorEnrichmentJobRequest
  ) extends zio.aws.sagemakergeospatial.model.GetVectorEnrichmentJobRequest.ReadOnly {
    override val arn: VectorEnrichmentJobArn =
      zio.aws.sagemakergeospatial.model.primitives
        .VectorEnrichmentJobArn(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.GetVectorEnrichmentJobRequest
  ): zio.aws.sagemakergeospatial.model.GetVectorEnrichmentJobRequest.ReadOnly =
    new Wrapper(impl)
}
