package zio.aws.sagemakergeospatial.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PlatformInput(
    comparisonOperator: Optional[
      zio.aws.sagemakergeospatial.model.ComparisonOperator
    ] = Optional.Absent,
    value: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.PlatformInput = {
    import PlatformInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.PlatformInput
      .builder()
      .optionallyWith(comparisonOperator.map(value => value.unwrap))(
        _.comparisonOperator
      )
      .value(value: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemakergeospatial.model.PlatformInput.ReadOnly =
    zio.aws.sagemakergeospatial.model.PlatformInput.wrap(buildAwsValue())
}
object PlatformInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.PlatformInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakergeospatial.model.PlatformInput =
      zio.aws.sagemakergeospatial.model
        .PlatformInput(comparisonOperator.map(value => value), value)
    def comparisonOperator
        : Optional[zio.aws.sagemakergeospatial.model.ComparisonOperator]
    def value: String
    def getComparisonOperator: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.ComparisonOperator
    ] = AwsError.unwrapOptionField("comparisonOperator", comparisonOperator)
    def getValue: ZIO[Any, Nothing, String] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.PlatformInput
  ) extends zio.aws.sagemakergeospatial.model.PlatformInput.ReadOnly {
    override val comparisonOperator
        : Optional[zio.aws.sagemakergeospatial.model.ComparisonOperator] =
      zio.aws.core.internal
        .optionalFromNullable(impl.comparisonOperator())
        .map(value =>
          zio.aws.sagemakergeospatial.model.ComparisonOperator.wrap(value)
        )
    override val value: String = impl.value(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.PlatformInput
  ): zio.aws.sagemakergeospatial.model.PlatformInput.ReadOnly = new Wrapper(
    impl
  )
}
