package zio.aws.sagemakergeospatial.model
import zio.aws.sagemakergeospatial.model.primitives.DataCollectionArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetRasterDataCollectionRequest(arn: DataCollectionArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.GetRasterDataCollectionRequest = {
    import GetRasterDataCollectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.GetRasterDataCollectionRequest
      .builder()
      .arn(DataCollectionArn.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.GetRasterDataCollectionRequest.ReadOnly =
    zio.aws.sagemakergeospatial.model.GetRasterDataCollectionRequest
      .wrap(buildAwsValue())
}
object GetRasterDataCollectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.GetRasterDataCollectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakergeospatial.model.GetRasterDataCollectionRequest =
      zio.aws.sagemakergeospatial.model.GetRasterDataCollectionRequest(arn)
    def arn: DataCollectionArn
    def getArn: ZIO[Any, Nothing, DataCollectionArn] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.GetRasterDataCollectionRequest
  ) extends zio.aws.sagemakergeospatial.model.GetRasterDataCollectionRequest.ReadOnly {
    override val arn: DataCollectionArn =
      zio.aws.sagemakergeospatial.model.primitives.DataCollectionArn(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.GetRasterDataCollectionRequest
  ): zio.aws.sagemakergeospatial.model.GetRasterDataCollectionRequest.ReadOnly =
    new Wrapper(impl)
}
