package zio.aws.sagemakergeospatial.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sagemakergeospatial.model.primitives.{
  KmsKey,
  ExecutionRoleArn,
  Integer,
  SyntheticTimestamp_date_time
}
import scala.jdk.CollectionConverters.*
final case class StartEarthObservationJobResponse(
    arn: String,
    creationTime: SyntheticTimestamp_date_time,
    durationInSeconds: Integer,
    executionRoleArn: Optional[ExecutionRoleArn] = Optional.Absent,
    inputConfig: Optional[zio.aws.sagemakergeospatial.model.InputConfigOutput] =
      Optional.Absent,
    jobConfig: zio.aws.sagemakergeospatial.model.JobConfigInput,
    kmsKeyId: Optional[KmsKey] = Optional.Absent,
    name: String,
    status: zio.aws.sagemakergeospatial.model.EarthObservationJobStatus,
    tags: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.StartEarthObservationJobResponse = {
    import StartEarthObservationJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.StartEarthObservationJobResponse
      .builder()
      .arn(arn: java.lang.String)
      .creationTime(SyntheticTimestamp_date_time.unwrap(creationTime): Instant)
      .durationInSeconds(durationInSeconds: java.lang.Integer)
      .optionallyWith(
        executionRoleArn.map(value =>
          ExecutionRoleArn.unwrap(value): java.lang.String
        )
      )(_.executionRoleArn)
      .optionallyWith(inputConfig.map(value => value.buildAwsValue()))(
        _.inputConfig
      )
      .jobConfig(jobConfig.buildAwsValue())
      .optionallyWith(
        kmsKeyId.map(value => KmsKey.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .name(name: java.lang.String)
      .status(status.unwrap)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.StartEarthObservationJobResponse.ReadOnly =
    zio.aws.sagemakergeospatial.model.StartEarthObservationJobResponse
      .wrap(buildAwsValue())
}
object StartEarthObservationJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.StartEarthObservationJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakergeospatial.model.StartEarthObservationJobResponse =
      zio.aws.sagemakergeospatial.model.StartEarthObservationJobResponse(
        arn,
        creationTime,
        durationInSeconds,
        executionRoleArn.map(value => value),
        inputConfig.map(value => value.asEditable),
        jobConfig.asEditable,
        kmsKeyId.map(value => value),
        name,
        status,
        tags.map(value => value)
      )
    def arn: String
    def creationTime: SyntheticTimestamp_date_time
    def durationInSeconds: Integer
    def executionRoleArn: Optional[ExecutionRoleArn]
    def inputConfig
        : Optional[zio.aws.sagemakergeospatial.model.InputConfigOutput.ReadOnly]
    def jobConfig: zio.aws.sagemakergeospatial.model.JobConfigInput.ReadOnly
    def kmsKeyId: Optional[KmsKey]
    def name: String
    def status: zio.aws.sagemakergeospatial.model.EarthObservationJobStatus
    def tags: Optional[Map[String, String]]
    def getArn: ZIO[Any, Nothing, String] = ZIO.succeed(arn)
    def getCreationTime: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(creationTime)
    def getDurationInSeconds: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(durationInSeconds)
    def getExecutionRoleArn: ZIO[Any, AwsError, ExecutionRoleArn] =
      AwsError.unwrapOptionField("executionRoleArn", executionRoleArn)
    def getInputConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.InputConfigOutput.ReadOnly
    ] = AwsError.unwrapOptionField("inputConfig", inputConfig)
    def getJobConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemakergeospatial.model.JobConfigInput.ReadOnly
    ] = ZIO.succeed(jobConfig)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKey] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getStatus: ZIO[
      Any,
      Nothing,
      zio.aws.sagemakergeospatial.model.EarthObservationJobStatus
    ] = ZIO.succeed(status)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.StartEarthObservationJobResponse
  ) extends zio.aws.sagemakergeospatial.model.StartEarthObservationJobResponse.ReadOnly {
    override val arn: String = impl.arn(): String
    override val creationTime: SyntheticTimestamp_date_time =
      zio.aws.sagemakergeospatial.model.primitives
        .SyntheticTimestamp_date_time(impl.creationTime())
    override val durationInSeconds: Integer = impl.durationInSeconds(): Integer
    override val executionRoleArn: Optional[ExecutionRoleArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionRoleArn())
        .map(value =>
          zio.aws.sagemakergeospatial.model.primitives.ExecutionRoleArn(value)
        )
    override val inputConfig: Optional[
      zio.aws.sagemakergeospatial.model.InputConfigOutput.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.inputConfig())
      .map(value =>
        zio.aws.sagemakergeospatial.model.InputConfigOutput.wrap(value)
      )
    override val jobConfig
        : zio.aws.sagemakergeospatial.model.JobConfigInput.ReadOnly =
      zio.aws.sagemakergeospatial.model.JobConfigInput.wrap(impl.jobConfig())
    override val kmsKeyId: Optional[KmsKey] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.sagemakergeospatial.model.primitives.KmsKey(value))
    override val name: String = impl.name(): String
    override val status
        : zio.aws.sagemakergeospatial.model.EarthObservationJobStatus =
      zio.aws.sagemakergeospatial.model.EarthObservationJobStatus
        .wrap(impl.status())
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.StartEarthObservationJobResponse
  ): zio.aws.sagemakergeospatial.model.StartEarthObservationJobResponse.ReadOnly =
    new Wrapper(impl)
}
