package zio.aws.sagemakergeospatial.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PropertyFilters(
    logicalOperator: Optional[
      zio.aws.sagemakergeospatial.model.LogicalOperator
    ] = Optional.Absent,
    properties: Optional[
      Iterable[zio.aws.sagemakergeospatial.model.PropertyFilter]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.PropertyFilters = {
    import PropertyFilters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.PropertyFilters
      .builder()
      .optionallyWith(logicalOperator.map(value => value.unwrap))(
        _.logicalOperator
      )
      .optionallyWith(
        properties.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.properties)
      .build()
  }
  def asReadOnly: zio.aws.sagemakergeospatial.model.PropertyFilters.ReadOnly =
    zio.aws.sagemakergeospatial.model.PropertyFilters.wrap(buildAwsValue())
}
object PropertyFilters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.PropertyFilters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakergeospatial.model.PropertyFilters =
      zio.aws.sagemakergeospatial.model.PropertyFilters(
        logicalOperator.map(value => value),
        properties.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def logicalOperator
        : Optional[zio.aws.sagemakergeospatial.model.LogicalOperator]
    def properties: Optional[
      List[zio.aws.sagemakergeospatial.model.PropertyFilter.ReadOnly]
    ]
    def getLogicalOperator: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.LogicalOperator
    ] = AwsError.unwrapOptionField("logicalOperator", logicalOperator)
    def getProperties: ZIO[Any, AwsError, List[
      zio.aws.sagemakergeospatial.model.PropertyFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("properties", properties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.PropertyFilters
  ) extends zio.aws.sagemakergeospatial.model.PropertyFilters.ReadOnly {
    override val logicalOperator
        : Optional[zio.aws.sagemakergeospatial.model.LogicalOperator] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logicalOperator())
        .map(value =>
          zio.aws.sagemakergeospatial.model.LogicalOperator.wrap(value)
        )
    override val properties: Optional[
      List[zio.aws.sagemakergeospatial.model.PropertyFilter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.properties())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemakergeospatial.model.PropertyFilter.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.PropertyFilters
  ): zio.aws.sagemakergeospatial.model.PropertyFilters.ReadOnly = new Wrapper(
    impl
  )
}
