package zio.aws.sagemakergeospatial.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class MultiPolygonGeometryInput(
    coordinates: Iterable[Iterable[Iterable[Iterable[Double]]]]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.MultiPolygonGeometryInput = {
    import MultiPolygonGeometryInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.MultiPolygonGeometryInput
      .builder()
      .coordinates(coordinates.map { item =>
        item.map { item =>
          item.map { item =>
            item.map { item =>
              item: java.lang.Double
            }.asJavaCollection
          }.asJavaCollection
        }.asJavaCollection
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.MultiPolygonGeometryInput.ReadOnly =
    zio.aws.sagemakergeospatial.model.MultiPolygonGeometryInput
      .wrap(buildAwsValue())
}
object MultiPolygonGeometryInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.MultiPolygonGeometryInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakergeospatial.model.MultiPolygonGeometryInput =
      zio.aws.sagemakergeospatial.model.MultiPolygonGeometryInput(coordinates)
    def coordinates: List[List[List[List[Double]]]]
    def getCoordinates: ZIO[Any, Nothing, List[List[List[List[Double]]]]] =
      ZIO.succeed(coordinates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.MultiPolygonGeometryInput
  ) extends zio.aws.sagemakergeospatial.model.MultiPolygonGeometryInput.ReadOnly {
    override val coordinates: List[List[List[List[Double]]]] = impl
      .coordinates()
      .asScala
      .map { item =>
        item.asScala.map { item =>
          item.asScala.map { item =>
            item.asScala.map { item =>
              item: Double
            }.toList
          }.toList
        }.toList
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.MultiPolygonGeometryInput
  ): zio.aws.sagemakergeospatial.model.MultiPolygonGeometryInput.ReadOnly =
    new Wrapper(impl)
}
