package zio.aws.sagemakergeospatial.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class EoCloudCoverInput(lowerBound: Float, upperBound: Float) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.EoCloudCoverInput = {
    import EoCloudCoverInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.EoCloudCoverInput
      .builder()
      .lowerBound(lowerBound: java.lang.Float)
      .upperBound(upperBound: java.lang.Float)
      .build()
  }
  def asReadOnly: zio.aws.sagemakergeospatial.model.EoCloudCoverInput.ReadOnly =
    zio.aws.sagemakergeospatial.model.EoCloudCoverInput.wrap(buildAwsValue())
}
object EoCloudCoverInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.EoCloudCoverInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakergeospatial.model.EoCloudCoverInput =
      zio.aws.sagemakergeospatial.model
        .EoCloudCoverInput(lowerBound, upperBound)
    def lowerBound: Float
    def upperBound: Float
    def getLowerBound: ZIO[Any, Nothing, Float] = ZIO.succeed(lowerBound)
    def getUpperBound: ZIO[Any, Nothing, Float] = ZIO.succeed(upperBound)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.EoCloudCoverInput
  ) extends zio.aws.sagemakergeospatial.model.EoCloudCoverInput.ReadOnly {
    override val lowerBound: Float = impl.lowerBound(): Float
    override val upperBound: Float = impl.upperBound(): Float
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.EoCloudCoverInput
  ): zio.aws.sagemakergeospatial.model.EoCloudCoverInput.ReadOnly = new Wrapper(
    impl
  )
}
