package zio.aws.sagemakergeospatial.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AreaOfInterestGeometry(
    multiPolygonGeometry: Optional[
      zio.aws.sagemakergeospatial.model.MultiPolygonGeometryInput
    ] = Optional.Absent,
    polygonGeometry: Optional[
      zio.aws.sagemakergeospatial.model.PolygonGeometryInput
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.AreaOfInterestGeometry = {
    import AreaOfInterestGeometry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.AreaOfInterestGeometry
      .builder()
      .optionallyWith(multiPolygonGeometry.map(value => value.buildAwsValue()))(
        _.multiPolygonGeometry
      )
      .optionallyWith(polygonGeometry.map(value => value.buildAwsValue()))(
        _.polygonGeometry
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.AreaOfInterestGeometry.ReadOnly =
    zio.aws.sagemakergeospatial.model.AreaOfInterestGeometry
      .wrap(buildAwsValue())
}
object AreaOfInterestGeometry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.AreaOfInterestGeometry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakergeospatial.model.AreaOfInterestGeometry =
      zio.aws.sagemakergeospatial.model.AreaOfInterestGeometry(
        multiPolygonGeometry.map(value => value.asEditable),
        polygonGeometry.map(value => value.asEditable)
      )
    def multiPolygonGeometry: Optional[
      zio.aws.sagemakergeospatial.model.MultiPolygonGeometryInput.ReadOnly
    ]
    def polygonGeometry: Optional[
      zio.aws.sagemakergeospatial.model.PolygonGeometryInput.ReadOnly
    ]
    def getMultiPolygonGeometry: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.MultiPolygonGeometryInput.ReadOnly
    ] = AwsError.unwrapOptionField("multiPolygonGeometry", multiPolygonGeometry)
    def getPolygonGeometry: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.PolygonGeometryInput.ReadOnly
    ] = AwsError.unwrapOptionField("polygonGeometry", polygonGeometry)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.AreaOfInterestGeometry
  ) extends zio.aws.sagemakergeospatial.model.AreaOfInterestGeometry.ReadOnly {
    override val multiPolygonGeometry: Optional[
      zio.aws.sagemakergeospatial.model.MultiPolygonGeometryInput.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.multiPolygonGeometry())
      .map(value =>
        zio.aws.sagemakergeospatial.model.MultiPolygonGeometryInput.wrap(value)
      )
    override val polygonGeometry: Optional[
      zio.aws.sagemakergeospatial.model.PolygonGeometryInput.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.polygonGeometry())
      .map(value =>
        zio.aws.sagemakergeospatial.model.PolygonGeometryInput.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.AreaOfInterestGeometry
  ): zio.aws.sagemakergeospatial.model.AreaOfInterestGeometry.ReadOnly =
    new Wrapper(impl)
}
