package zio.aws.sagemakergeospatial.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AreaOfInterest(
    areaOfInterestGeometry: Optional[
      zio.aws.sagemakergeospatial.model.AreaOfInterestGeometry
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.AreaOfInterest = {
    import AreaOfInterest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.AreaOfInterest
      .builder()
      .optionallyWith(
        areaOfInterestGeometry.map(value => value.buildAwsValue())
      )(_.areaOfInterestGeometry)
      .build()
  }
  def asReadOnly: zio.aws.sagemakergeospatial.model.AreaOfInterest.ReadOnly =
    zio.aws.sagemakergeospatial.model.AreaOfInterest.wrap(buildAwsValue())
}
object AreaOfInterest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.AreaOfInterest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakergeospatial.model.AreaOfInterest =
      zio.aws.sagemakergeospatial.model
        .AreaOfInterest(areaOfInterestGeometry.map(value => value.asEditable))
    def areaOfInterestGeometry: Optional[
      zio.aws.sagemakergeospatial.model.AreaOfInterestGeometry.ReadOnly
    ]
    def getAreaOfInterestGeometry: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.AreaOfInterestGeometry.ReadOnly
    ] = AwsError.unwrapOptionField(
      "areaOfInterestGeometry",
      areaOfInterestGeometry
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.AreaOfInterest
  ) extends zio.aws.sagemakergeospatial.model.AreaOfInterest.ReadOnly {
    override val areaOfInterestGeometry: Optional[
      zio.aws.sagemakergeospatial.model.AreaOfInterestGeometry.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.areaOfInterestGeometry())
      .map(value =>
        zio.aws.sagemakergeospatial.model.AreaOfInterestGeometry.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.AreaOfInterest
  ): zio.aws.sagemakergeospatial.model.AreaOfInterest.ReadOnly = new Wrapper(
    impl
  )
}
