package zio.aws.sagemakergeospatial.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Operation(
    equation: String,
    name: String,
    outputType: Optional[zio.aws.sagemakergeospatial.model.OutputType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.Operation = {
    import Operation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.Operation
      .builder()
      .equation(equation: java.lang.String)
      .name(name: java.lang.String)
      .optionallyWith(outputType.map(value => value.unwrap))(_.outputType)
      .build()
  }
  def asReadOnly: zio.aws.sagemakergeospatial.model.Operation.ReadOnly =
    zio.aws.sagemakergeospatial.model.Operation.wrap(buildAwsValue())
}
object Operation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.Operation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakergeospatial.model.Operation =
      zio.aws.sagemakergeospatial.model
        .Operation(equation, name, outputType.map(value => value))
    def equation: String
    def name: String
    def outputType: Optional[zio.aws.sagemakergeospatial.model.OutputType]
    def getEquation: ZIO[Any, Nothing, String] = ZIO.succeed(equation)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getOutputType
        : ZIO[Any, AwsError, zio.aws.sagemakergeospatial.model.OutputType] =
      AwsError.unwrapOptionField("outputType", outputType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.Operation
  ) extends zio.aws.sagemakergeospatial.model.Operation.ReadOnly {
    override val equation: String = impl.equation(): String
    override val name: String = impl.name(): String
    override val outputType
        : Optional[zio.aws.sagemakergeospatial.model.OutputType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputType())
        .map(value => zio.aws.sagemakergeospatial.model.OutputType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.Operation
  ): zio.aws.sagemakergeospatial.model.Operation.ReadOnly = new Wrapper(impl)
}
