package zio.aws.sagemakergeospatial.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sagemakergeospatial.model.primitives.{
  VectorEnrichmentJobArn,
  ExecutionRoleArn,
  SyntheticTimestamp_date_time,
  KmsKey,
  Integer
}
import scala.jdk.CollectionConverters.*
final case class StartVectorEnrichmentJobResponse(
    arn: VectorEnrichmentJobArn,
    creationTime: SyntheticTimestamp_date_time,
    durationInSeconds: Integer,
    executionRoleArn: ExecutionRoleArn,
    inputConfig: zio.aws.sagemakergeospatial.model.VectorEnrichmentJobInputConfig,
    jobConfig: zio.aws.sagemakergeospatial.model.VectorEnrichmentJobConfig,
    kmsKeyId: Optional[KmsKey] = Optional.Absent,
    name: String,
    status: zio.aws.sagemakergeospatial.model.VectorEnrichmentJobStatus,
    tags: Optional[Map[String, String]] = Optional.Absent,
    `type`: zio.aws.sagemakergeospatial.model.VectorEnrichmentJobType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.StartVectorEnrichmentJobResponse = {
    import StartVectorEnrichmentJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.StartVectorEnrichmentJobResponse
      .builder()
      .arn(VectorEnrichmentJobArn.unwrap(arn): java.lang.String)
      .creationTime(SyntheticTimestamp_date_time.unwrap(creationTime): Instant)
      .durationInSeconds(durationInSeconds: java.lang.Integer)
      .executionRoleArn(
        ExecutionRoleArn.unwrap(executionRoleArn): java.lang.String
      )
      .inputConfig(inputConfig.buildAwsValue())
      .jobConfig(jobConfig.buildAwsValue())
      .optionallyWith(
        kmsKeyId.map(value => KmsKey.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .name(name: java.lang.String)
      .status(status.unwrap)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.StartVectorEnrichmentJobResponse.ReadOnly =
    zio.aws.sagemakergeospatial.model.StartVectorEnrichmentJobResponse
      .wrap(buildAwsValue())
}
object StartVectorEnrichmentJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.StartVectorEnrichmentJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakergeospatial.model.StartVectorEnrichmentJobResponse =
      zio.aws.sagemakergeospatial.model.StartVectorEnrichmentJobResponse(
        arn,
        creationTime,
        durationInSeconds,
        executionRoleArn,
        inputConfig.asEditable,
        jobConfig.asEditable,
        kmsKeyId.map(value => value),
        name,
        status,
        tags.map(value => value),
        `type`
      )
    def arn: VectorEnrichmentJobArn
    def creationTime: SyntheticTimestamp_date_time
    def durationInSeconds: Integer
    def executionRoleArn: ExecutionRoleArn
    def inputConfig
        : zio.aws.sagemakergeospatial.model.VectorEnrichmentJobInputConfig.ReadOnly
    def jobConfig
        : zio.aws.sagemakergeospatial.model.VectorEnrichmentJobConfig.ReadOnly
    def kmsKeyId: Optional[KmsKey]
    def name: String
    def status: zio.aws.sagemakergeospatial.model.VectorEnrichmentJobStatus
    def tags: Optional[Map[String, String]]
    def `type`: zio.aws.sagemakergeospatial.model.VectorEnrichmentJobType
    def getArn: ZIO[Any, Nothing, VectorEnrichmentJobArn] = ZIO.succeed(arn)
    def getCreationTime: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(creationTime)
    def getDurationInSeconds: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(durationInSeconds)
    def getExecutionRoleArn: ZIO[Any, Nothing, ExecutionRoleArn] =
      ZIO.succeed(executionRoleArn)
    def getInputConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobInputConfig.ReadOnly
    ] = ZIO.succeed(inputConfig)
    def getJobConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobConfig.ReadOnly
    ] = ZIO.succeed(jobConfig)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKey] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getStatus: ZIO[
      Any,
      Nothing,
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobStatus
    ] = ZIO.succeed(status)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
    def getType: ZIO[
      Any,
      Nothing,
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobType
    ] = ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.StartVectorEnrichmentJobResponse
  ) extends zio.aws.sagemakergeospatial.model.StartVectorEnrichmentJobResponse.ReadOnly {
    override val arn: VectorEnrichmentJobArn =
      zio.aws.sagemakergeospatial.model.primitives
        .VectorEnrichmentJobArn(impl.arn())
    override val creationTime: SyntheticTimestamp_date_time =
      zio.aws.sagemakergeospatial.model.primitives
        .SyntheticTimestamp_date_time(impl.creationTime())
    override val durationInSeconds: Integer = impl.durationInSeconds(): Integer
    override val executionRoleArn: ExecutionRoleArn =
      zio.aws.sagemakergeospatial.model.primitives
        .ExecutionRoleArn(impl.executionRoleArn())
    override val inputConfig
        : zio.aws.sagemakergeospatial.model.VectorEnrichmentJobInputConfig.ReadOnly =
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobInputConfig
        .wrap(impl.inputConfig())
    override val jobConfig
        : zio.aws.sagemakergeospatial.model.VectorEnrichmentJobConfig.ReadOnly =
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobConfig
        .wrap(impl.jobConfig())
    override val kmsKeyId: Optional[KmsKey] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.sagemakergeospatial.model.primitives.KmsKey(value))
    override val name: String = impl.name(): String
    override val status
        : zio.aws.sagemakergeospatial.model.VectorEnrichmentJobStatus =
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobStatus
        .wrap(impl.status())
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val `type`
        : zio.aws.sagemakergeospatial.model.VectorEnrichmentJobType =
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobType
        .wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.StartVectorEnrichmentJobResponse
  ): zio.aws.sagemakergeospatial.model.StartVectorEnrichmentJobResponse.ReadOnly =
    new Wrapper(impl)
}
