package zio.aws.sagemakergeospatial.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PropertyFilter(
    property: zio.aws.sagemakergeospatial.model.Property
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.PropertyFilter = {
    import PropertyFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.PropertyFilter
      .builder()
      .property(property.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.sagemakergeospatial.model.PropertyFilter.ReadOnly =
    zio.aws.sagemakergeospatial.model.PropertyFilter.wrap(buildAwsValue())
}
object PropertyFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.PropertyFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakergeospatial.model.PropertyFilter =
      zio.aws.sagemakergeospatial.model.PropertyFilter(property.asEditable)
    def property: zio.aws.sagemakergeospatial.model.Property.ReadOnly
    def getProperty: ZIO[
      Any,
      Nothing,
      zio.aws.sagemakergeospatial.model.Property.ReadOnly
    ] = ZIO.succeed(property)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.PropertyFilter
  ) extends zio.aws.sagemakergeospatial.model.PropertyFilter.ReadOnly {
    override val property: zio.aws.sagemakergeospatial.model.Property.ReadOnly =
      zio.aws.sagemakergeospatial.model.Property.wrap(impl.property())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.PropertyFilter
  ): zio.aws.sagemakergeospatial.model.PropertyFilter.ReadOnly = new Wrapper(
    impl
  )
}
