package zio.aws.sagemakergeospatial.model
import zio.aws.sagemakergeospatial.model.primitives.EarthObservationJobArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetEarthObservationJobRequest(arn: EarthObservationJobArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.GetEarthObservationJobRequest = {
    import GetEarthObservationJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.GetEarthObservationJobRequest
      .builder()
      .arn(EarthObservationJobArn.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.GetEarthObservationJobRequest.ReadOnly =
    zio.aws.sagemakergeospatial.model.GetEarthObservationJobRequest
      .wrap(buildAwsValue())
}
object GetEarthObservationJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.GetEarthObservationJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakergeospatial.model.GetEarthObservationJobRequest =
      zio.aws.sagemakergeospatial.model.GetEarthObservationJobRequest(arn)
    def arn: EarthObservationJobArn
    def getArn: ZIO[Any, Nothing, EarthObservationJobArn] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.GetEarthObservationJobRequest
  ) extends zio.aws.sagemakergeospatial.model.GetEarthObservationJobRequest.ReadOnly {
    override val arn: EarthObservationJobArn =
      zio.aws.sagemakergeospatial.model.primitives
        .EarthObservationJobArn(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.GetEarthObservationJobRequest
  ): zio.aws.sagemakergeospatial.model.GetEarthObservationJobRequest.ReadOnly =
    new Wrapper(impl)
}
