package zio.aws.sagemakergeospatial.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StartEarthObservationJobRequest(
    clientToken: Optional[String] = Optional.Absent,
    executionRoleArn: Optional[String] = Optional.Absent,
    inputConfig: zio.aws.sagemakergeospatial.model.InputConfigInput,
    jobConfig: zio.aws.sagemakergeospatial.model.JobConfigInput,
    kmsKeyId: Optional[String] = Optional.Absent,
    name: String,
    tags: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.StartEarthObservationJobRequest = {
    import StartEarthObservationJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.StartEarthObservationJobRequest
      .builder()
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(executionRoleArn.map(value => value: java.lang.String))(
        _.executionRoleArn
      )
      .inputConfig(inputConfig.buildAwsValue())
      .jobConfig(jobConfig.buildAwsValue())
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .name(name: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.StartEarthObservationJobRequest.ReadOnly =
    zio.aws.sagemakergeospatial.model.StartEarthObservationJobRequest
      .wrap(buildAwsValue())
}
object StartEarthObservationJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.StartEarthObservationJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakergeospatial.model.StartEarthObservationJobRequest =
      zio.aws.sagemakergeospatial.model.StartEarthObservationJobRequest(
        clientToken.map(value => value),
        executionRoleArn.map(value => value),
        inputConfig.asEditable,
        jobConfig.asEditable,
        kmsKeyId.map(value => value),
        name,
        tags.map(value => value)
      )
    def clientToken: Optional[String]
    def executionRoleArn: Optional[String]
    def inputConfig: zio.aws.sagemakergeospatial.model.InputConfigInput.ReadOnly
    def jobConfig: zio.aws.sagemakergeospatial.model.JobConfigInput.ReadOnly
    def kmsKeyId: Optional[String]
    def name: String
    def tags: Optional[Map[String, String]]
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getExecutionRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("executionRoleArn", executionRoleArn)
    def getInputConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemakergeospatial.model.InputConfigInput.ReadOnly
    ] = ZIO.succeed(inputConfig)
    def getJobConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemakergeospatial.model.JobConfigInput.ReadOnly
    ] = ZIO.succeed(jobConfig)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.StartEarthObservationJobRequest
  ) extends zio.aws.sagemakergeospatial.model.StartEarthObservationJobRequest.ReadOnly {
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val executionRoleArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.executionRoleArn())
      .map(value => value: String)
    override val inputConfig
        : zio.aws.sagemakergeospatial.model.InputConfigInput.ReadOnly =
      zio.aws.sagemakergeospatial.model.InputConfigInput
        .wrap(impl.inputConfig())
    override val jobConfig
        : zio.aws.sagemakergeospatial.model.JobConfigInput.ReadOnly =
      zio.aws.sagemakergeospatial.model.JobConfigInput.wrap(impl.jobConfig())
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val name: String = impl.name(): String
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.StartEarthObservationJobRequest
  ): zio.aws.sagemakergeospatial.model.StartEarthObservationJobRequest.ReadOnly =
    new Wrapper(impl)
}
