package zio.aws.sagemakergeospatial.model
import zio.aws.sagemakergeospatial.model.primitives.{NextToken, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SearchRasterDataCollectionResponse(
    approximateResultCount: Integer,
    items: Optional[Iterable[zio.aws.sagemakergeospatial.model.ItemSource]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.SearchRasterDataCollectionResponse = {
    import SearchRasterDataCollectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.SearchRasterDataCollectionResponse
      .builder()
      .approximateResultCount(approximateResultCount: java.lang.Integer)
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.SearchRasterDataCollectionResponse.ReadOnly =
    zio.aws.sagemakergeospatial.model.SearchRasterDataCollectionResponse
      .wrap(buildAwsValue())
}
object SearchRasterDataCollectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.SearchRasterDataCollectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakergeospatial.model.SearchRasterDataCollectionResponse =
      zio.aws.sagemakergeospatial.model.SearchRasterDataCollectionResponse(
        approximateResultCount,
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def approximateResultCount: Integer
    def items
        : Optional[List[zio.aws.sagemakergeospatial.model.ItemSource.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getApproximateResultCount: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(approximateResultCount)
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.sagemakergeospatial.model.ItemSource.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.SearchRasterDataCollectionResponse
  ) extends zio.aws.sagemakergeospatial.model.SearchRasterDataCollectionResponse.ReadOnly {
    override val approximateResultCount: Integer =
      impl.approximateResultCount(): Integer
    override val items: Optional[
      List[zio.aws.sagemakergeospatial.model.ItemSource.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.items())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemakergeospatial.model.ItemSource.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.sagemakergeospatial.model.primitives.NextToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.SearchRasterDataCollectionResponse
  ): zio.aws.sagemakergeospatial.model.SearchRasterDataCollectionResponse.ReadOnly =
    new Wrapper(impl)
}
