package zio.aws.sagemakergeospatial.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sagemakergeospatial.model.primitives.Timestamp
import scala.jdk.CollectionConverters.*
final case class ItemSource(
    assets: Optional[
      Map[String, zio.aws.sagemakergeospatial.model.AssetValue]
    ] = Optional.Absent,
    dateTime: Timestamp,
    geometry: zio.aws.sagemakergeospatial.model.Geometry,
    id: String,
    properties: Optional[zio.aws.sagemakergeospatial.model.Properties] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.ItemSource = {
    import ItemSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.ItemSource
      .builder()
      .optionallyWith(
        assets.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.assets)
      .dateTime(Timestamp.unwrap(dateTime): Instant)
      .geometry(geometry.buildAwsValue())
      .id(id: java.lang.String)
      .optionallyWith(properties.map(value => value.buildAwsValue()))(
        _.properties
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemakergeospatial.model.ItemSource.ReadOnly =
    zio.aws.sagemakergeospatial.model.ItemSource.wrap(buildAwsValue())
}
object ItemSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.ItemSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakergeospatial.model.ItemSource =
      zio.aws.sagemakergeospatial.model.ItemSource(
        assets.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        dateTime,
        geometry.asEditable,
        id,
        properties.map(value => value.asEditable)
      )
    def assets: Optional[
      Map[String, zio.aws.sagemakergeospatial.model.AssetValue.ReadOnly]
    ]
    def dateTime: Timestamp
    def geometry: zio.aws.sagemakergeospatial.model.Geometry.ReadOnly
    def id: String
    def properties
        : Optional[zio.aws.sagemakergeospatial.model.Properties.ReadOnly]
    def getAssets: ZIO[Any, AwsError, Map[
      String,
      zio.aws.sagemakergeospatial.model.AssetValue.ReadOnly
    ]] = AwsError.unwrapOptionField("assets", assets)
    def getDateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(dateTime)
    def getGeometry: ZIO[
      Any,
      Nothing,
      zio.aws.sagemakergeospatial.model.Geometry.ReadOnly
    ] = ZIO.succeed(geometry)
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getProperties: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.Properties.ReadOnly
    ] = AwsError.unwrapOptionField("properties", properties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.ItemSource
  ) extends zio.aws.sagemakergeospatial.model.ItemSource.ReadOnly {
    override val assets: Optional[
      Map[String, zio.aws.sagemakergeospatial.model.AssetValue.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.assets())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> zio.aws.sagemakergeospatial.model.AssetValue
              .wrap(value)
          })
          .toMap
      )
    override val dateTime: Timestamp =
      zio.aws.sagemakergeospatial.model.primitives.Timestamp(impl.dateTime())
    override val geometry: zio.aws.sagemakergeospatial.model.Geometry.ReadOnly =
      zio.aws.sagemakergeospatial.model.Geometry.wrap(impl.geometry())
    override val id: String = impl.id(): String
    override val properties
        : Optional[zio.aws.sagemakergeospatial.model.Properties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.properties())
        .map(value => zio.aws.sagemakergeospatial.model.Properties.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.ItemSource
  ): zio.aws.sagemakergeospatial.model.ItemSource.ReadOnly = new Wrapper(impl)
}
