package zio.aws.sagemakergeospatial.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sagemakergeospatial.model.primitives.{
  Timestamp,
  EarthObservationJobArn
}
import scala.jdk.CollectionConverters.*
final case class ExportEarthObservationJobResponse(
    arn: EarthObservationJobArn,
    creationTime: Timestamp,
    executionRoleArn: String,
    exportSourceImages: Optional[Boolean] = Optional.Absent,
    exportStatus: zio.aws.sagemakergeospatial.model.EarthObservationJobExportStatus,
    outputConfig: zio.aws.sagemakergeospatial.model.OutputConfigInput
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.ExportEarthObservationJobResponse = {
    import ExportEarthObservationJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.ExportEarthObservationJobResponse
      .builder()
      .arn(EarthObservationJobArn.unwrap(arn): java.lang.String)
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .executionRoleArn(executionRoleArn: java.lang.String)
      .optionallyWith(
        exportSourceImages.map(value => value: java.lang.Boolean)
      )(_.exportSourceImages)
      .exportStatus(exportStatus.unwrap)
      .outputConfig(outputConfig.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.ExportEarthObservationJobResponse.ReadOnly =
    zio.aws.sagemakergeospatial.model.ExportEarthObservationJobResponse
      .wrap(buildAwsValue())
}
object ExportEarthObservationJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.ExportEarthObservationJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakergeospatial.model.ExportEarthObservationJobResponse =
      zio.aws.sagemakergeospatial.model.ExportEarthObservationJobResponse(
        arn,
        creationTime,
        executionRoleArn,
        exportSourceImages.map(value => value),
        exportStatus,
        outputConfig.asEditable
      )
    def arn: EarthObservationJobArn
    def creationTime: Timestamp
    def executionRoleArn: String
    def exportSourceImages: Optional[Boolean]
    def exportStatus
        : zio.aws.sagemakergeospatial.model.EarthObservationJobExportStatus
    def outputConfig
        : zio.aws.sagemakergeospatial.model.OutputConfigInput.ReadOnly
    def getArn: ZIO[Any, Nothing, EarthObservationJobArn] = ZIO.succeed(arn)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getExecutionRoleArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(executionRoleArn)
    def getExportSourceImages: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("exportSourceImages", exportSourceImages)
    def getExportStatus: ZIO[
      Any,
      Nothing,
      zio.aws.sagemakergeospatial.model.EarthObservationJobExportStatus
    ] = ZIO.succeed(exportStatus)
    def getOutputConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemakergeospatial.model.OutputConfigInput.ReadOnly
    ] = ZIO.succeed(outputConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.ExportEarthObservationJobResponse
  ) extends zio.aws.sagemakergeospatial.model.ExportEarthObservationJobResponse.ReadOnly {
    override val arn: EarthObservationJobArn =
      zio.aws.sagemakergeospatial.model.primitives
        .EarthObservationJobArn(impl.arn())
    override val creationTime: Timestamp =
      zio.aws.sagemakergeospatial.model.primitives
        .Timestamp(impl.creationTime())
    override val executionRoleArn: String = impl.executionRoleArn(): String
    override val exportSourceImages: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.exportSourceImages())
      .map(value => value: Boolean)
    override val exportStatus
        : zio.aws.sagemakergeospatial.model.EarthObservationJobExportStatus =
      zio.aws.sagemakergeospatial.model.EarthObservationJobExportStatus
        .wrap(impl.exportStatus())
    override val outputConfig
        : zio.aws.sagemakergeospatial.model.OutputConfigInput.ReadOnly =
      zio.aws.sagemakergeospatial.model.OutputConfigInput
        .wrap(impl.outputConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.ExportEarthObservationJobResponse
  ): zio.aws.sagemakergeospatial.model.ExportEarthObservationJobResponse.ReadOnly =
    new Wrapper(impl)
}
