package zio.aws.sagemakergeospatial.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GeoMosaicConfigInput(
    algorithmName: Optional[
      zio.aws.sagemakergeospatial.model.AlgorithmNameGeoMosaic
    ] = Optional.Absent,
    targetBands: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.GeoMosaicConfigInput = {
    import GeoMosaicConfigInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.GeoMosaicConfigInput
      .builder()
      .optionallyWith(algorithmName.map(value => value.unwrap))(_.algorithmName)
      .optionallyWith(
        targetBands.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.targetBands)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.GeoMosaicConfigInput.ReadOnly =
    zio.aws.sagemakergeospatial.model.GeoMosaicConfigInput.wrap(buildAwsValue())
}
object GeoMosaicConfigInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.GeoMosaicConfigInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakergeospatial.model.GeoMosaicConfigInput =
      zio.aws.sagemakergeospatial.model.GeoMosaicConfigInput(
        algorithmName.map(value => value),
        targetBands.map(value => value)
      )
    def algorithmName
        : Optional[zio.aws.sagemakergeospatial.model.AlgorithmNameGeoMosaic]
    def targetBands: Optional[List[String]]
    def getAlgorithmName: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.AlgorithmNameGeoMosaic
    ] = AwsError.unwrapOptionField("algorithmName", algorithmName)
    def getTargetBands: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("targetBands", targetBands)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.GeoMosaicConfigInput
  ) extends zio.aws.sagemakergeospatial.model.GeoMosaicConfigInput.ReadOnly {
    override val algorithmName
        : Optional[zio.aws.sagemakergeospatial.model.AlgorithmNameGeoMosaic] =
      zio.aws.core.internal
        .optionalFromNullable(impl.algorithmName())
        .map(value =>
          zio.aws.sagemakergeospatial.model.AlgorithmNameGeoMosaic.wrap(value)
        )
    override val targetBands: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.targetBands())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.GeoMosaicConfigInput
  ): zio.aws.sagemakergeospatial.model.GeoMosaicConfigInput.ReadOnly =
    new Wrapper(impl)
}
