package zio.aws.sagemakergeospatial.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class VectorEnrichmentJobS3Data(
    kmsKeyId: Optional[String] = Optional.Absent,
    s3Uri: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.VectorEnrichmentJobS3Data = {
    import VectorEnrichmentJobS3Data.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.VectorEnrichmentJobS3Data
      .builder()
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .s3Uri(s3Uri: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.VectorEnrichmentJobS3Data.ReadOnly =
    zio.aws.sagemakergeospatial.model.VectorEnrichmentJobS3Data
      .wrap(buildAwsValue())
}
object VectorEnrichmentJobS3Data {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.VectorEnrichmentJobS3Data
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakergeospatial.model.VectorEnrichmentJobS3Data =
      zio.aws.sagemakergeospatial.model
        .VectorEnrichmentJobS3Data(kmsKeyId.map(value => value), s3Uri)
    def kmsKeyId: Optional[String]
    def s3Uri: String
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getS3Uri: ZIO[Any, Nothing, String] = ZIO.succeed(s3Uri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.VectorEnrichmentJobS3Data
  ) extends zio.aws.sagemakergeospatial.model.VectorEnrichmentJobS3Data.ReadOnly {
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val s3Uri: String = impl.s3Uri(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.VectorEnrichmentJobS3Data
  ): zio.aws.sagemakergeospatial.model.VectorEnrichmentJobS3Data.ReadOnly =
    new Wrapper(impl)
}
