package zio.aws.sagemakergeospatial.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StackConfigInput(
    outputResolution: Optional[
      zio.aws.sagemakergeospatial.model.OutputResolutionStackInput
    ] = Optional.Absent,
    targetBands: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.StackConfigInput = {
    import StackConfigInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.StackConfigInput
      .builder()
      .optionallyWith(outputResolution.map(value => value.buildAwsValue()))(
        _.outputResolution
      )
      .optionallyWith(
        targetBands.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.targetBands)
      .build()
  }
  def asReadOnly: zio.aws.sagemakergeospatial.model.StackConfigInput.ReadOnly =
    zio.aws.sagemakergeospatial.model.StackConfigInput.wrap(buildAwsValue())
}
object StackConfigInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.StackConfigInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakergeospatial.model.StackConfigInput =
      zio.aws.sagemakergeospatial.model.StackConfigInput(
        outputResolution.map(value => value.asEditable),
        targetBands.map(value => value)
      )
    def outputResolution: Optional[
      zio.aws.sagemakergeospatial.model.OutputResolutionStackInput.ReadOnly
    ]
    def targetBands: Optional[List[String]]
    def getOutputResolution: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.OutputResolutionStackInput.ReadOnly
    ] = AwsError.unwrapOptionField("outputResolution", outputResolution)
    def getTargetBands: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("targetBands", targetBands)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.StackConfigInput
  ) extends zio.aws.sagemakergeospatial.model.StackConfigInput.ReadOnly {
    override val outputResolution: Optional[
      zio.aws.sagemakergeospatial.model.OutputResolutionStackInput.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.outputResolution())
      .map(value =>
        zio.aws.sagemakergeospatial.model.OutputResolutionStackInput.wrap(value)
      )
    override val targetBands: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.targetBands())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.StackConfigInput
  ): zio.aws.sagemakergeospatial.model.StackConfigInput.ReadOnly = new Wrapper(
    impl
  )
}
