package zio.aws.sagemakergeospatial.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class S3DataInput(
    kmsKeyId: Optional[String] = Optional.Absent,
    metadataProvider: zio.aws.sagemakergeospatial.model.MetadataProvider,
    s3Uri: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.S3DataInput = {
    import S3DataInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.S3DataInput
      .builder()
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .metadataProvider(metadataProvider.unwrap)
      .s3Uri(s3Uri: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemakergeospatial.model.S3DataInput.ReadOnly =
    zio.aws.sagemakergeospatial.model.S3DataInput.wrap(buildAwsValue())
}
object S3DataInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.S3DataInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakergeospatial.model.S3DataInput =
      zio.aws.sagemakergeospatial.model
        .S3DataInput(kmsKeyId.map(value => value), metadataProvider, s3Uri)
    def kmsKeyId: Optional[String]
    def metadataProvider: zio.aws.sagemakergeospatial.model.MetadataProvider
    def s3Uri: String
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getMetadataProvider: ZIO[
      Any,
      Nothing,
      zio.aws.sagemakergeospatial.model.MetadataProvider
    ] = ZIO.succeed(metadataProvider)
    def getS3Uri: ZIO[Any, Nothing, String] = ZIO.succeed(s3Uri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.S3DataInput
  ) extends zio.aws.sagemakergeospatial.model.S3DataInput.ReadOnly {
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val metadataProvider
        : zio.aws.sagemakergeospatial.model.MetadataProvider =
      zio.aws.sagemakergeospatial.model.MetadataProvider
        .wrap(impl.metadataProvider())
    override val s3Uri: String = impl.s3Uri(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.S3DataInput
  ): zio.aws.sagemakergeospatial.model.S3DataInput.ReadOnly = new Wrapper(impl)
}
