package zio.aws.sagemakergeospatial.model
import zio.aws.sagemakergeospatial.model.primitives.VectorEnrichmentJobArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ExportVectorEnrichmentJobRequest(
    arn: VectorEnrichmentJobArn,
    executionRoleArn: String,
    outputConfig: zio.aws.sagemakergeospatial.model.ExportVectorEnrichmentJobOutputConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.ExportVectorEnrichmentJobRequest = {
    import ExportVectorEnrichmentJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.ExportVectorEnrichmentJobRequest
      .builder()
      .arn(VectorEnrichmentJobArn.unwrap(arn): java.lang.String)
      .executionRoleArn(executionRoleArn: java.lang.String)
      .outputConfig(outputConfig.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.ExportVectorEnrichmentJobRequest.ReadOnly =
    zio.aws.sagemakergeospatial.model.ExportVectorEnrichmentJobRequest
      .wrap(buildAwsValue())
}
object ExportVectorEnrichmentJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.ExportVectorEnrichmentJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakergeospatial.model.ExportVectorEnrichmentJobRequest =
      zio.aws.sagemakergeospatial.model.ExportVectorEnrichmentJobRequest(
        arn,
        executionRoleArn,
        outputConfig.asEditable
      )
    def arn: VectorEnrichmentJobArn
    def executionRoleArn: String
    def outputConfig
        : zio.aws.sagemakergeospatial.model.ExportVectorEnrichmentJobOutputConfig.ReadOnly
    def getArn: ZIO[Any, Nothing, VectorEnrichmentJobArn] = ZIO.succeed(arn)
    def getExecutionRoleArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(executionRoleArn)
    def getOutputConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemakergeospatial.model.ExportVectorEnrichmentJobOutputConfig.ReadOnly
    ] = ZIO.succeed(outputConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.ExportVectorEnrichmentJobRequest
  ) extends zio.aws.sagemakergeospatial.model.ExportVectorEnrichmentJobRequest.ReadOnly {
    override val arn: VectorEnrichmentJobArn =
      zio.aws.sagemakergeospatial.model.primitives
        .VectorEnrichmentJobArn(impl.arn())
    override val executionRoleArn: String = impl.executionRoleArn(): String
    override val outputConfig
        : zio.aws.sagemakergeospatial.model.ExportVectorEnrichmentJobOutputConfig.ReadOnly =
      zio.aws.sagemakergeospatial.model.ExportVectorEnrichmentJobOutputConfig
        .wrap(impl.outputConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.ExportVectorEnrichmentJobRequest
  ): zio.aws.sagemakergeospatial.model.ExportVectorEnrichmentJobRequest.ReadOnly =
    new Wrapper(impl)
}
