package zio.aws.sagemakergeospatial.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BandMathConfigInput(
    customIndices: Optional[
      zio.aws.sagemakergeospatial.model.CustomIndicesInput
    ] = Optional.Absent,
    predefinedIndices: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.BandMathConfigInput = {
    import BandMathConfigInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.BandMathConfigInput
      .builder()
      .optionallyWith(customIndices.map(value => value.buildAwsValue()))(
        _.customIndices
      )
      .optionallyWith(
        predefinedIndices.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.predefinedIndices)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.BandMathConfigInput.ReadOnly =
    zio.aws.sagemakergeospatial.model.BandMathConfigInput.wrap(buildAwsValue())
}
object BandMathConfigInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.BandMathConfigInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakergeospatial.model.BandMathConfigInput =
      zio.aws.sagemakergeospatial.model.BandMathConfigInput(
        customIndices.map(value => value.asEditable),
        predefinedIndices.map(value => value)
      )
    def customIndices: Optional[
      zio.aws.sagemakergeospatial.model.CustomIndicesInput.ReadOnly
    ]
    def predefinedIndices: Optional[List[String]]
    def getCustomIndices: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.CustomIndicesInput.ReadOnly
    ] = AwsError.unwrapOptionField("customIndices", customIndices)
    def getPredefinedIndices: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("predefinedIndices", predefinedIndices)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.BandMathConfigInput
  ) extends zio.aws.sagemakergeospatial.model.BandMathConfigInput.ReadOnly {
    override val customIndices: Optional[
      zio.aws.sagemakergeospatial.model.CustomIndicesInput.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.customIndices())
      .map(value =>
        zio.aws.sagemakergeospatial.model.CustomIndicesInput.wrap(value)
      )
    override val predefinedIndices: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.predefinedIndices())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.BandMathConfigInput
  ): zio.aws.sagemakergeospatial.model.BandMathConfigInput.ReadOnly =
    new Wrapper(impl)
}
