package zio.aws.sagemakergeospatial.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ZonalStatisticsConfigInput(
    statistics: Iterable[zio.aws.sagemakergeospatial.model.ZonalStatistics],
    targetBands: Optional[Iterable[String]] = Optional.Absent,
    zoneS3Path: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.ZonalStatisticsConfigInput = {
    import ZonalStatisticsConfigInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.ZonalStatisticsConfigInput
      .builder()
      .statisticsWithStrings(statistics.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(
        targetBands.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.targetBands)
      .zoneS3Path(zoneS3Path: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.ZonalStatisticsConfigInput.ReadOnly =
    zio.aws.sagemakergeospatial.model.ZonalStatisticsConfigInput
      .wrap(buildAwsValue())
}
object ZonalStatisticsConfigInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.ZonalStatisticsConfigInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakergeospatial.model.ZonalStatisticsConfigInput =
      zio.aws.sagemakergeospatial.model.ZonalStatisticsConfigInput(
        statistics,
        targetBands.map(value => value),
        zoneS3Path
      )
    def statistics: List[zio.aws.sagemakergeospatial.model.ZonalStatistics]
    def targetBands: Optional[List[String]]
    def zoneS3Path: String
    def getStatistics: ZIO[Any, Nothing, List[
      zio.aws.sagemakergeospatial.model.ZonalStatistics
    ]] = ZIO.succeed(statistics)
    def getTargetBands: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("targetBands", targetBands)
    def getZoneS3Path: ZIO[Any, Nothing, String] = ZIO.succeed(zoneS3Path)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.ZonalStatisticsConfigInput
  ) extends zio.aws.sagemakergeospatial.model.ZonalStatisticsConfigInput.ReadOnly {
    override val statistics
        : List[zio.aws.sagemakergeospatial.model.ZonalStatistics] = impl
      .statistics()
      .asScala
      .map { item =>
        zio.aws.sagemakergeospatial.model.ZonalStatistics.wrap(item)
      }
      .toList
    override val targetBands: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.targetBands())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val zoneS3Path: String = impl.zoneS3Path(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.ZonalStatisticsConfigInput
  ): zio.aws.sagemakergeospatial.model.ZonalStatisticsConfigInput.ReadOnly =
    new Wrapper(impl)
}
