package zio.aws.sagemakergeospatial.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RasterDataCollectionQueryOutput(
    areaOfInterest: Optional[zio.aws.sagemakergeospatial.model.AreaOfInterest] =
      Optional.Absent,
    propertyFilters: Optional[
      zio.aws.sagemakergeospatial.model.PropertyFilters
    ] = Optional.Absent,
    rasterDataCollectionArn: String,
    rasterDataCollectionName: String,
    timeRangeFilter: zio.aws.sagemakergeospatial.model.TimeRangeFilterInput
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.RasterDataCollectionQueryOutput = {
    import RasterDataCollectionQueryOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.RasterDataCollectionQueryOutput
      .builder()
      .optionallyWith(areaOfInterest.map(value => value.buildAwsValue()))(
        _.areaOfInterest
      )
      .optionallyWith(propertyFilters.map(value => value.buildAwsValue()))(
        _.propertyFilters
      )
      .rasterDataCollectionArn(rasterDataCollectionArn: java.lang.String)
      .rasterDataCollectionName(rasterDataCollectionName: java.lang.String)
      .timeRangeFilter(timeRangeFilter.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.RasterDataCollectionQueryOutput.ReadOnly =
    zio.aws.sagemakergeospatial.model.RasterDataCollectionQueryOutput
      .wrap(buildAwsValue())
}
object RasterDataCollectionQueryOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.RasterDataCollectionQueryOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakergeospatial.model.RasterDataCollectionQueryOutput =
      zio.aws.sagemakergeospatial.model.RasterDataCollectionQueryOutput(
        areaOfInterest.map(value => value.asEditable),
        propertyFilters.map(value => value.asEditable),
        rasterDataCollectionArn,
        rasterDataCollectionName,
        timeRangeFilter.asEditable
      )
    def areaOfInterest
        : Optional[zio.aws.sagemakergeospatial.model.AreaOfInterest.ReadOnly]
    def propertyFilters
        : Optional[zio.aws.sagemakergeospatial.model.PropertyFilters.ReadOnly]
    def rasterDataCollectionArn: String
    def rasterDataCollectionName: String
    def timeRangeFilter
        : zio.aws.sagemakergeospatial.model.TimeRangeFilterInput.ReadOnly
    def getAreaOfInterest: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.AreaOfInterest.ReadOnly
    ] = AwsError.unwrapOptionField("areaOfInterest", areaOfInterest)
    def getPropertyFilters: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.PropertyFilters.ReadOnly
    ] = AwsError.unwrapOptionField("propertyFilters", propertyFilters)
    def getRasterDataCollectionArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(rasterDataCollectionArn)
    def getRasterDataCollectionName: ZIO[Any, Nothing, String] =
      ZIO.succeed(rasterDataCollectionName)
    def getTimeRangeFilter: ZIO[
      Any,
      Nothing,
      zio.aws.sagemakergeospatial.model.TimeRangeFilterInput.ReadOnly
    ] = ZIO.succeed(timeRangeFilter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.RasterDataCollectionQueryOutput
  ) extends zio.aws.sagemakergeospatial.model.RasterDataCollectionQueryOutput.ReadOnly {
    override val areaOfInterest
        : Optional[zio.aws.sagemakergeospatial.model.AreaOfInterest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.areaOfInterest())
        .map(value =>
          zio.aws.sagemakergeospatial.model.AreaOfInterest.wrap(value)
        )
    override val propertyFilters
        : Optional[zio.aws.sagemakergeospatial.model.PropertyFilters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.propertyFilters())
        .map(value =>
          zio.aws.sagemakergeospatial.model.PropertyFilters.wrap(value)
        )
    override val rasterDataCollectionArn: String =
      impl.rasterDataCollectionArn(): String
    override val rasterDataCollectionName: String =
      impl.rasterDataCollectionName(): String
    override val timeRangeFilter
        : zio.aws.sagemakergeospatial.model.TimeRangeFilterInput.ReadOnly =
      zio.aws.sagemakergeospatial.model.TimeRangeFilterInput
        .wrap(impl.timeRangeFilter())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.RasterDataCollectionQueryOutput
  ): zio.aws.sagemakergeospatial.model.RasterDataCollectionQueryOutput.ReadOnly =
    new Wrapper(impl)
}
