package zio.aws.sagemakergeospatial.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sagemakergeospatial.model.primitives.{Integer, Timestamp}
import scala.jdk.CollectionConverters.*
final case class GetVectorEnrichmentJobResponse(
    arn: String,
    creationTime: Timestamp,
    durationInSeconds: Integer,
    errorDetails: Optional[
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobErrorDetails
    ] = Optional.Absent,
    executionRoleArn: String,
    exportErrorDetails: Optional[
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobExportErrorDetails
    ] = Optional.Absent,
    exportStatus: Optional[
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobExportStatus
    ] = Optional.Absent,
    inputConfig: zio.aws.sagemakergeospatial.model.VectorEnrichmentJobInputConfig,
    jobConfig: zio.aws.sagemakergeospatial.model.VectorEnrichmentJobConfig,
    kmsKeyId: Optional[String] = Optional.Absent,
    name: String,
    status: zio.aws.sagemakergeospatial.model.VectorEnrichmentJobStatus,
    tags: Optional[Map[String, String]] = Optional.Absent,
    `type`: zio.aws.sagemakergeospatial.model.VectorEnrichmentJobType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.GetVectorEnrichmentJobResponse = {
    import GetVectorEnrichmentJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.GetVectorEnrichmentJobResponse
      .builder()
      .arn(arn: java.lang.String)
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .durationInSeconds(durationInSeconds: java.lang.Integer)
      .optionallyWith(errorDetails.map(value => value.buildAwsValue()))(
        _.errorDetails
      )
      .executionRoleArn(executionRoleArn: java.lang.String)
      .optionallyWith(exportErrorDetails.map(value => value.buildAwsValue()))(
        _.exportErrorDetails
      )
      .optionallyWith(exportStatus.map(value => value.unwrap))(_.exportStatus)
      .inputConfig(inputConfig.buildAwsValue())
      .jobConfig(jobConfig.buildAwsValue())
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .name(name: java.lang.String)
      .status(status.unwrap)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.GetVectorEnrichmentJobResponse.ReadOnly =
    zio.aws.sagemakergeospatial.model.GetVectorEnrichmentJobResponse
      .wrap(buildAwsValue())
}
object GetVectorEnrichmentJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.GetVectorEnrichmentJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakergeospatial.model.GetVectorEnrichmentJobResponse =
      zio.aws.sagemakergeospatial.model.GetVectorEnrichmentJobResponse(
        arn,
        creationTime,
        durationInSeconds,
        errorDetails.map(value => value.asEditable),
        executionRoleArn,
        exportErrorDetails.map(value => value.asEditable),
        exportStatus.map(value => value),
        inputConfig.asEditable,
        jobConfig.asEditable,
        kmsKeyId.map(value => value),
        name,
        status,
        tags.map(value => value),
        `type`
      )
    def arn: String
    def creationTime: Timestamp
    def durationInSeconds: Integer
    def errorDetails: Optional[
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobErrorDetails.ReadOnly
    ]
    def executionRoleArn: String
    def exportErrorDetails: Optional[
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobExportErrorDetails.ReadOnly
    ]
    def exportStatus: Optional[
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobExportStatus
    ]
    def inputConfig
        : zio.aws.sagemakergeospatial.model.VectorEnrichmentJobInputConfig.ReadOnly
    def jobConfig
        : zio.aws.sagemakergeospatial.model.VectorEnrichmentJobConfig.ReadOnly
    def kmsKeyId: Optional[String]
    def name: String
    def status: zio.aws.sagemakergeospatial.model.VectorEnrichmentJobStatus
    def tags: Optional[Map[String, String]]
    def `type`: zio.aws.sagemakergeospatial.model.VectorEnrichmentJobType
    def getArn: ZIO[Any, Nothing, String] = ZIO.succeed(arn)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getDurationInSeconds: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(durationInSeconds)
    def getErrorDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobErrorDetails.ReadOnly
    ] = AwsError.unwrapOptionField("errorDetails", errorDetails)
    def getExecutionRoleArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(executionRoleArn)
    def getExportErrorDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobExportErrorDetails.ReadOnly
    ] = AwsError.unwrapOptionField("exportErrorDetails", exportErrorDetails)
    def getExportStatus: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobExportStatus
    ] = AwsError.unwrapOptionField("exportStatus", exportStatus)
    def getInputConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobInputConfig.ReadOnly
    ] = ZIO.succeed(inputConfig)
    def getJobConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobConfig.ReadOnly
    ] = ZIO.succeed(jobConfig)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getStatus: ZIO[
      Any,
      Nothing,
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobStatus
    ] = ZIO.succeed(status)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
    def getType: ZIO[
      Any,
      Nothing,
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobType
    ] = ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.GetVectorEnrichmentJobResponse
  ) extends zio.aws.sagemakergeospatial.model.GetVectorEnrichmentJobResponse.ReadOnly {
    override val arn: String = impl.arn(): String
    override val creationTime: Timestamp =
      zio.aws.sagemakergeospatial.model.primitives
        .Timestamp(impl.creationTime())
    override val durationInSeconds: Integer = impl.durationInSeconds(): Integer
    override val errorDetails: Optional[
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobErrorDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.errorDetails())
      .map(value =>
        zio.aws.sagemakergeospatial.model.VectorEnrichmentJobErrorDetails
          .wrap(value)
      )
    override val executionRoleArn: String = impl.executionRoleArn(): String
    override val exportErrorDetails: Optional[
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobExportErrorDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.exportErrorDetails())
      .map(value =>
        zio.aws.sagemakergeospatial.model.VectorEnrichmentJobExportErrorDetails
          .wrap(value)
      )
    override val exportStatus: Optional[
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobExportStatus
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.exportStatus())
      .map(value =>
        zio.aws.sagemakergeospatial.model.VectorEnrichmentJobExportStatus
          .wrap(value)
      )
    override val inputConfig
        : zio.aws.sagemakergeospatial.model.VectorEnrichmentJobInputConfig.ReadOnly =
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobInputConfig
        .wrap(impl.inputConfig())
    override val jobConfig
        : zio.aws.sagemakergeospatial.model.VectorEnrichmentJobConfig.ReadOnly =
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobConfig
        .wrap(impl.jobConfig())
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val name: String = impl.name(): String
    override val status
        : zio.aws.sagemakergeospatial.model.VectorEnrichmentJobStatus =
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobStatus
        .wrap(impl.status())
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val `type`
        : zio.aws.sagemakergeospatial.model.VectorEnrichmentJobType =
      zio.aws.sagemakergeospatial.model.VectorEnrichmentJobType
        .wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.GetVectorEnrichmentJobResponse
  ): zio.aws.sagemakergeospatial.model.GetVectorEnrichmentJobResponse.ReadOnly =
    new Wrapper(impl)
}
