package zio.aws.sagemakergeospatial.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ExportS3DataInput(
    kmsKeyId: Optional[String] = Optional.Absent,
    s3Uri: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.ExportS3DataInput = {
    import ExportS3DataInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.ExportS3DataInput
      .builder()
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .s3Uri(s3Uri: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemakergeospatial.model.ExportS3DataInput.ReadOnly =
    zio.aws.sagemakergeospatial.model.ExportS3DataInput.wrap(buildAwsValue())
}
object ExportS3DataInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.ExportS3DataInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakergeospatial.model.ExportS3DataInput =
      zio.aws.sagemakergeospatial.model
        .ExportS3DataInput(kmsKeyId.map(value => value), s3Uri)
    def kmsKeyId: Optional[String]
    def s3Uri: String
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getS3Uri: ZIO[Any, Nothing, String] = ZIO.succeed(s3Uri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.ExportS3DataInput
  ) extends zio.aws.sagemakergeospatial.model.ExportS3DataInput.ReadOnly {
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val s3Uri: String = impl.s3Uri(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.ExportS3DataInput
  ): zio.aws.sagemakergeospatial.model.ExportS3DataInput.ReadOnly = new Wrapper(
    impl
  )
}
