package zio.aws.sagemakergeospatial.model
import scala.jdk.CollectionConverters.*
sealed trait ExportErrorType {
  def unwrap: software.amazon.awssdk.services.sagemakergeospatial.model.ExportErrorType
}
object ExportErrorType {
  def wrap(
      value: software.amazon.awssdk.services.sagemakergeospatial.model.ExportErrorType
  ): zio.aws.sagemakergeospatial.model.ExportErrorType = value match {
    case software.amazon.awssdk.services.sagemakergeospatial.model.ExportErrorType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemakergeospatial.model.ExportErrorType.CLIENT_ERROR =>
      val r = CLIENT_ERROR
      r
    case software.amazon.awssdk.services.sagemakergeospatial.model.ExportErrorType.SERVER_ERROR =>
      val r = SERVER_ERROR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemakergeospatial.model.ExportErrorType {
    override def unwrap
        : software.amazon.awssdk.services.sagemakergeospatial.model.ExportErrorType =
      software.amazon.awssdk.services.sagemakergeospatial.model.ExportErrorType.UNKNOWN_TO_SDK_VERSION
  }
  case object CLIENT_ERROR
      extends zio.aws.sagemakergeospatial.model.ExportErrorType {
    override def unwrap
        : software.amazon.awssdk.services.sagemakergeospatial.model.ExportErrorType =
      software.amazon.awssdk.services.sagemakergeospatial.model.ExportErrorType.CLIENT_ERROR
  }
  case object SERVER_ERROR
      extends zio.aws.sagemakergeospatial.model.ExportErrorType {
    override def unwrap
        : software.amazon.awssdk.services.sagemakergeospatial.model.ExportErrorType =
      software.amazon.awssdk.services.sagemakergeospatial.model.ExportErrorType.SERVER_ERROR
  }
}
