package zio.aws.sagemakergeospatial.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ExportErrorDetailsOutput(
    message: Optional[String] = Optional.Absent,
    `type`: Optional[zio.aws.sagemakergeospatial.model.ExportErrorType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.ExportErrorDetailsOutput = {
    import ExportErrorDetailsOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.ExportErrorDetailsOutput
      .builder()
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.ExportErrorDetailsOutput.ReadOnly =
    zio.aws.sagemakergeospatial.model.ExportErrorDetailsOutput
      .wrap(buildAwsValue())
}
object ExportErrorDetailsOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.ExportErrorDetailsOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakergeospatial.model.ExportErrorDetailsOutput =
      zio.aws.sagemakergeospatial.model.ExportErrorDetailsOutput(
        message.map(value => value),
        `type`.map(value => value)
      )
    def message: Optional[String]
    def `type`: Optional[zio.aws.sagemakergeospatial.model.ExportErrorType]
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
    def getType: ZIO[
      Any,
      AwsError,
      zio.aws.sagemakergeospatial.model.ExportErrorType
    ] = AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.ExportErrorDetailsOutput
  ) extends zio.aws.sagemakergeospatial.model.ExportErrorDetailsOutput.ReadOnly {
    override val message: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: String)
    override val `type`
        : Optional[zio.aws.sagemakergeospatial.model.ExportErrorType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value =>
          zio.aws.sagemakergeospatial.model.ExportErrorType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.ExportErrorDetailsOutput
  ): zio.aws.sagemakergeospatial.model.ExportErrorDetailsOutput.ReadOnly =
    new Wrapper(impl)
}
