package zio.aws.sagemakergeospatial.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PolygonGeometryInput(
    coordinates: Iterable[Iterable[Iterable[Double]]]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.PolygonGeometryInput = {
    import PolygonGeometryInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.PolygonGeometryInput
      .builder()
      .coordinates(coordinates.map { item =>
        item.map { item =>
          item.map { item =>
            item: java.lang.Double
          }.asJavaCollection
        }.asJavaCollection
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.PolygonGeometryInput.ReadOnly =
    zio.aws.sagemakergeospatial.model.PolygonGeometryInput.wrap(buildAwsValue())
}
object PolygonGeometryInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.PolygonGeometryInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemakergeospatial.model.PolygonGeometryInput =
      zio.aws.sagemakergeospatial.model.PolygonGeometryInput(coordinates)
    def coordinates: List[List[List[Double]]]
    def getCoordinates: ZIO[Any, Nothing, List[List[List[Double]]]] =
      ZIO.succeed(coordinates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.PolygonGeometryInput
  ) extends zio.aws.sagemakergeospatial.model.PolygonGeometryInput.ReadOnly {
    override val coordinates: List[List[List[Double]]] = impl
      .coordinates()
      .asScala
      .map { item =>
        item.asScala.map { item =>
          item.asScala.map { item =>
            item: Double
          }.toList
        }.toList
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.PolygonGeometryInput
  ): zio.aws.sagemakergeospatial.model.PolygonGeometryInput.ReadOnly =
    new Wrapper(impl)
}
