package zio.aws.sagemakergeospatial.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TemporalStatisticsConfigInput(
    groupBy: Optional[zio.aws.sagemakergeospatial.model.GroupBy] =
      Optional.Absent,
    statistics: Iterable[zio.aws.sagemakergeospatial.model.TemporalStatistics],
    targetBands: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.TemporalStatisticsConfigInput = {
    import TemporalStatisticsConfigInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.TemporalStatisticsConfigInput
      .builder()
      .optionallyWith(groupBy.map(value => value.unwrap))(_.groupBy)
      .statisticsWithStrings(statistics.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(
        targetBands.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.targetBands)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.TemporalStatisticsConfigInput.ReadOnly =
    zio.aws.sagemakergeospatial.model.TemporalStatisticsConfigInput
      .wrap(buildAwsValue())
}
object TemporalStatisticsConfigInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.TemporalStatisticsConfigInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakergeospatial.model.TemporalStatisticsConfigInput =
      zio.aws.sagemakergeospatial.model.TemporalStatisticsConfigInput(
        groupBy.map(value => value),
        statistics,
        targetBands.map(value => value)
      )
    def groupBy: Optional[zio.aws.sagemakergeospatial.model.GroupBy]
    def statistics: List[zio.aws.sagemakergeospatial.model.TemporalStatistics]
    def targetBands: Optional[List[String]]
    def getGroupBy
        : ZIO[Any, AwsError, zio.aws.sagemakergeospatial.model.GroupBy] =
      AwsError.unwrapOptionField("groupBy", groupBy)
    def getStatistics: ZIO[Any, Nothing, List[
      zio.aws.sagemakergeospatial.model.TemporalStatistics
    ]] = ZIO.succeed(statistics)
    def getTargetBands: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("targetBands", targetBands)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.TemporalStatisticsConfigInput
  ) extends zio.aws.sagemakergeospatial.model.TemporalStatisticsConfigInput.ReadOnly {
    override val groupBy: Optional[zio.aws.sagemakergeospatial.model.GroupBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.groupBy())
        .map(value => zio.aws.sagemakergeospatial.model.GroupBy.wrap(value))
    override val statistics
        : List[zio.aws.sagemakergeospatial.model.TemporalStatistics] = impl
      .statistics()
      .asScala
      .map { item =>
        zio.aws.sagemakergeospatial.model.TemporalStatistics.wrap(item)
      }
      .toList
    override val targetBands: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.targetBands())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.TemporalStatisticsConfigInput
  ): zio.aws.sagemakergeospatial.model.TemporalStatisticsConfigInput.ReadOnly =
    new Wrapper(impl)
}
