package zio.aws.sagemakergeospatial.model
import zio.aws.sagemakergeospatial.model.primitives.DataCollectionArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RasterDataCollectionMetadata(
    arn: DataCollectionArn,
    description: String,
    descriptionPageUrl: Optional[String] = Optional.Absent,
    name: String,
    supportedFilters: Iterable[zio.aws.sagemakergeospatial.model.Filter],
    tags: Optional[Map[String, String]] = Optional.Absent,
    `type`: zio.aws.sagemakergeospatial.model.DataCollectionType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemakergeospatial.model.RasterDataCollectionMetadata = {
    import RasterDataCollectionMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemakergeospatial.model.RasterDataCollectionMetadata
      .builder()
      .arn(DataCollectionArn.unwrap(arn): java.lang.String)
      .description(description: java.lang.String)
      .optionallyWith(descriptionPageUrl.map(value => value: java.lang.String))(
        _.descriptionPageUrl
      )
      .name(name: java.lang.String)
      .supportedFilters(supportedFilters.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemakergeospatial.model.RasterDataCollectionMetadata.ReadOnly =
    zio.aws.sagemakergeospatial.model.RasterDataCollectionMetadata
      .wrap(buildAwsValue())
}
object RasterDataCollectionMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemakergeospatial.model.RasterDataCollectionMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemakergeospatial.model.RasterDataCollectionMetadata =
      zio.aws.sagemakergeospatial.model.RasterDataCollectionMetadata(
        arn,
        description,
        descriptionPageUrl.map(value => value),
        name,
        supportedFilters.map { item =>
          item.asEditable
        },
        tags.map(value => value),
        `type`
      )
    def arn: DataCollectionArn
    def description: String
    def descriptionPageUrl: Optional[String]
    def name: String
    def supportedFilters
        : List[zio.aws.sagemakergeospatial.model.Filter.ReadOnly]
    def tags: Optional[Map[String, String]]
    def `type`: zio.aws.sagemakergeospatial.model.DataCollectionType
    def getArn: ZIO[Any, Nothing, DataCollectionArn] = ZIO.succeed(arn)
    def getDescription: ZIO[Any, Nothing, String] = ZIO.succeed(description)
    def getDescriptionPageUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("descriptionPageUrl", descriptionPageUrl)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getSupportedFilters: ZIO[Any, Nothing, List[
      zio.aws.sagemakergeospatial.model.Filter.ReadOnly
    ]] = ZIO.succeed(supportedFilters)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
    def getType: ZIO[
      Any,
      Nothing,
      zio.aws.sagemakergeospatial.model.DataCollectionType
    ] = ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.RasterDataCollectionMetadata
  ) extends zio.aws.sagemakergeospatial.model.RasterDataCollectionMetadata.ReadOnly {
    override val arn: DataCollectionArn =
      zio.aws.sagemakergeospatial.model.primitives.DataCollectionArn(impl.arn())
    override val description: String = impl.description(): String
    override val descriptionPageUrl: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.descriptionPageUrl())
      .map(value => value: String)
    override val name: String = impl.name(): String
    override val supportedFilters
        : List[zio.aws.sagemakergeospatial.model.Filter.ReadOnly] = impl
      .supportedFilters()
      .asScala
      .map { item =>
        zio.aws.sagemakergeospatial.model.Filter.wrap(item)
      }
      .toList
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val `type`: zio.aws.sagemakergeospatial.model.DataCollectionType =
      zio.aws.sagemakergeospatial.model.DataCollectionType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemakergeospatial.model.RasterDataCollectionMetadata
  ): zio.aws.sagemakergeospatial.model.RasterDataCollectionMetadata.ReadOnly =
    new Wrapper(impl)
}
