package zio.aws.sagemakergeospatial
import zio.aws.sagemakergeospatial.model.GetVectorEnrichmentJobResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.sagemakergeospatial.SageMakerGeospatialAsyncClient
import zio.aws.sagemakergeospatial.model.{
  StopEarthObservationJobRequest,
  DeleteVectorEnrichmentJobRequest,
  ListRasterDataCollectionsRequest,
  GetEarthObservationJobRequest,
  ListEarthObservationJobsRequest,
  SearchRasterDataCollectionRequest,
  GetTileRequest,
  DeleteEarthObservationJobRequest,
  ListTagsForResourceRequest,
  GetRasterDataCollectionRequest,
  StartVectorEnrichmentJobRequest,
  StartEarthObservationJobRequest,
  GetVectorEnrichmentJobRequest,
  ExportEarthObservationJobRequest,
  StopVectorEnrichmentJobRequest,
  UntagResourceRequest,
  ExportVectorEnrichmentJobRequest,
  TagResourceRequest,
  ListVectorEnrichmentJobsRequest
}
import zio.aws.core.{StreamingOutputResult, AwsError}
import zio.aws.core.aspects.AwsCallAspect
import zio.{ZIO, IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object SageMakerGeospatialMock extends Mock[SageMakerGeospatial] {
  object GetVectorEnrichmentJob
      extends Effect[GetVectorEnrichmentJobRequest, AwsError, ReadOnly]
  object StopVectorEnrichmentJob
      extends Effect[
        StopVectorEnrichmentJobRequest,
        AwsError,
        zio.aws.sagemakergeospatial.model.StopVectorEnrichmentJobResponse.ReadOnly
      ]
  object StartVectorEnrichmentJob
      extends Effect[
        StartVectorEnrichmentJobRequest,
        AwsError,
        zio.aws.sagemakergeospatial.model.StartVectorEnrichmentJobResponse.ReadOnly
      ]
  object StartEarthObservationJob
      extends Effect[
        StartEarthObservationJobRequest,
        AwsError,
        zio.aws.sagemakergeospatial.model.StartEarthObservationJobResponse.ReadOnly
      ]
  object GetEarthObservationJob
      extends Effect[
        GetEarthObservationJobRequest,
        AwsError,
        zio.aws.sagemakergeospatial.model.GetEarthObservationJobResponse.ReadOnly
      ]
  object ListEarthObservationJobs
      extends Stream[
        ListEarthObservationJobsRequest,
        AwsError,
        zio.aws.sagemakergeospatial.model.ListEarthObservationJobOutputConfig.ReadOnly
      ]
  object ListEarthObservationJobsPaginated
      extends Effect[
        ListEarthObservationJobsRequest,
        AwsError,
        zio.aws.sagemakergeospatial.model.ListEarthObservationJobsResponse.ReadOnly
      ]
  object ListRasterDataCollections
      extends Stream[
        ListRasterDataCollectionsRequest,
        AwsError,
        zio.aws.sagemakergeospatial.model.RasterDataCollectionMetadata.ReadOnly
      ]
  object ListRasterDataCollectionsPaginated
      extends Effect[
        ListRasterDataCollectionsRequest,
        AwsError,
        zio.aws.sagemakergeospatial.model.ListRasterDataCollectionsResponse.ReadOnly
      ]
  object DeleteEarthObservationJob
      extends Effect[
        DeleteEarthObservationJobRequest,
        AwsError,
        zio.aws.sagemakergeospatial.model.DeleteEarthObservationJobResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.sagemakergeospatial.model.UntagResourceResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.sagemakergeospatial.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.sagemakergeospatial.model.TagResourceResponse.ReadOnly
      ]
  object DeleteVectorEnrichmentJob
      extends Effect[
        DeleteVectorEnrichmentJobRequest,
        AwsError,
        zio.aws.sagemakergeospatial.model.DeleteVectorEnrichmentJobResponse.ReadOnly
      ]
  object ExportVectorEnrichmentJob
      extends Effect[
        ExportVectorEnrichmentJobRequest,
        AwsError,
        zio.aws.sagemakergeospatial.model.ExportVectorEnrichmentJobResponse.ReadOnly
      ]
  object GetTile
      extends Effect[GetTileRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.sagemakergeospatial.model.GetTileResponse.ReadOnly,
        Byte
      ]]
  object ListVectorEnrichmentJobs
      extends Stream[
        ListVectorEnrichmentJobsRequest,
        AwsError,
        zio.aws.sagemakergeospatial.model.ListVectorEnrichmentJobOutputConfig.ReadOnly
      ]
  object ListVectorEnrichmentJobsPaginated
      extends Effect[
        ListVectorEnrichmentJobsRequest,
        AwsError,
        zio.aws.sagemakergeospatial.model.ListVectorEnrichmentJobsResponse.ReadOnly
      ]
  object GetRasterDataCollection
      extends Effect[
        GetRasterDataCollectionRequest,
        AwsError,
        zio.aws.sagemakergeospatial.model.GetRasterDataCollectionResponse.ReadOnly
      ]
  object ExportEarthObservationJob
      extends Effect[
        ExportEarthObservationJobRequest,
        AwsError,
        zio.aws.sagemakergeospatial.model.ExportEarthObservationJobResponse.ReadOnly
      ]
  object StopEarthObservationJob
      extends Effect[
        StopEarthObservationJobRequest,
        AwsError,
        zio.aws.sagemakergeospatial.model.StopEarthObservationJobResponse.ReadOnly
      ]
  object SearchRasterDataCollection
      extends Effect[
        SearchRasterDataCollectionRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.sagemakergeospatial.model.SearchRasterDataCollectionResponse.ReadOnly,
          zio.aws.sagemakergeospatial.model.ItemSource.ReadOnly
        ]
      ]
  object SearchRasterDataCollectionPaginated
      extends Effect[
        SearchRasterDataCollectionRequest,
        AwsError,
        zio.aws.sagemakergeospatial.model.SearchRasterDataCollectionResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, SageMakerGeospatial] = zio.ZLayer {
    ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, SageMakerGeospatial] { rts =>
        ZIO.succeed {
          new SageMakerGeospatial {
            val api: SageMakerGeospatialAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): SageMakerGeospatial = this
            def getVectorEnrichmentJob(
                request: GetVectorEnrichmentJobRequest
            ): IO[AwsError, ReadOnly] = proxy(GetVectorEnrichmentJob, request)
            def stopVectorEnrichmentJob(
                request: StopVectorEnrichmentJobRequest
            ): IO[
              AwsError,
              zio.aws.sagemakergeospatial.model.StopVectorEnrichmentJobResponse.ReadOnly
            ] = proxy(StopVectorEnrichmentJob, request)
            def startVectorEnrichmentJob(
                request: StartVectorEnrichmentJobRequest
            ): IO[
              AwsError,
              zio.aws.sagemakergeospatial.model.StartVectorEnrichmentJobResponse.ReadOnly
            ] = proxy(StartVectorEnrichmentJob, request)
            def startEarthObservationJob(
                request: StartEarthObservationJobRequest
            ): IO[
              AwsError,
              zio.aws.sagemakergeospatial.model.StartEarthObservationJobResponse.ReadOnly
            ] = proxy(StartEarthObservationJob, request)
            def getEarthObservationJob(
                request: GetEarthObservationJobRequest
            ): IO[
              AwsError,
              zio.aws.sagemakergeospatial.model.GetEarthObservationJobResponse.ReadOnly
            ] = proxy(GetEarthObservationJob, request)
            def listEarthObservationJobs(
                request: ListEarthObservationJobsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.sagemakergeospatial.model.ListEarthObservationJobOutputConfig.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListEarthObservationJobs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listEarthObservationJobsPaginated(
                request: ListEarthObservationJobsRequest
            ): IO[
              AwsError,
              zio.aws.sagemakergeospatial.model.ListEarthObservationJobsResponse.ReadOnly
            ] = proxy(ListEarthObservationJobsPaginated, request)
            def listRasterDataCollections(
                request: ListRasterDataCollectionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.sagemakergeospatial.model.RasterDataCollectionMetadata.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListRasterDataCollections, request)
                }
                .getOrThrowFiberFailure()
            }
            def listRasterDataCollectionsPaginated(
                request: ListRasterDataCollectionsRequest
            ): IO[
              AwsError,
              zio.aws.sagemakergeospatial.model.ListRasterDataCollectionsResponse.ReadOnly
            ] = proxy(ListRasterDataCollectionsPaginated, request)
            def deleteEarthObservationJob(
                request: DeleteEarthObservationJobRequest
            ): IO[
              AwsError,
              zio.aws.sagemakergeospatial.model.DeleteEarthObservationJobResponse.ReadOnly
            ] = proxy(DeleteEarthObservationJob, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.sagemakergeospatial.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.sagemakergeospatial.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.sagemakergeospatial.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def deleteVectorEnrichmentJob(
                request: DeleteVectorEnrichmentJobRequest
            ): IO[
              AwsError,
              zio.aws.sagemakergeospatial.model.DeleteVectorEnrichmentJobResponse.ReadOnly
            ] = proxy(DeleteVectorEnrichmentJob, request)
            def exportVectorEnrichmentJob(
                request: ExportVectorEnrichmentJobRequest
            ): IO[
              AwsError,
              zio.aws.sagemakergeospatial.model.ExportVectorEnrichmentJobResponse.ReadOnly
            ] = proxy(ExportVectorEnrichmentJob, request)
            def getTile(
                request: GetTileRequest
            ): IO[AwsError, StreamingOutputResult[
              Any,
              zio.aws.sagemakergeospatial.model.GetTileResponse.ReadOnly,
              Byte
            ]] = proxy(GetTile, request)
            def listVectorEnrichmentJobs(
                request: ListVectorEnrichmentJobsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.sagemakergeospatial.model.ListVectorEnrichmentJobOutputConfig.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListVectorEnrichmentJobs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listVectorEnrichmentJobsPaginated(
                request: ListVectorEnrichmentJobsRequest
            ): IO[
              AwsError,
              zio.aws.sagemakergeospatial.model.ListVectorEnrichmentJobsResponse.ReadOnly
            ] = proxy(ListVectorEnrichmentJobsPaginated, request)
            def getRasterDataCollection(
                request: GetRasterDataCollectionRequest
            ): IO[
              AwsError,
              zio.aws.sagemakergeospatial.model.GetRasterDataCollectionResponse.ReadOnly
            ] = proxy(GetRasterDataCollection, request)
            def exportEarthObservationJob(
                request: ExportEarthObservationJobRequest
            ): IO[
              AwsError,
              zio.aws.sagemakergeospatial.model.ExportEarthObservationJobResponse.ReadOnly
            ] = proxy(ExportEarthObservationJob, request)
            def stopEarthObservationJob(
                request: StopEarthObservationJobRequest
            ): IO[
              AwsError,
              zio.aws.sagemakergeospatial.model.StopEarthObservationJobResponse.ReadOnly
            ] = proxy(StopEarthObservationJob, request)
            def searchRasterDataCollection(
                request: SearchRasterDataCollectionRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.sagemakergeospatial.model.SearchRasterDataCollectionResponse.ReadOnly,
              zio.aws.sagemakergeospatial.model.ItemSource.ReadOnly
            ]] = proxy(SearchRasterDataCollection, request)
            def searchRasterDataCollectionPaginated(
                request: SearchRasterDataCollectionRequest
            ): IO[
              AwsError,
              zio.aws.sagemakergeospatial.model.SearchRasterDataCollectionResponse.ReadOnly
            ] = proxy(SearchRasterDataCollectionPaginated, request)
          }
        }
      }
    }
  }
}
